/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;



public class LocalizationUnitType {
	
	public static LocalizationUnit merge(LocalizationUnit unit1, LocalizationUnit unit2)
	{
		
		/*<LocalizationUnitType> 	 	 	 	
		id 	xsd:ID 	Throw Away
		targetResourceRef 	xsd:IDREF 	Yes
		any 	namespace="##other" 	 ?
	Identity 		<IdentityType> 	Merge
	Condition 		<ConditionType> 	Merge
	Variables 		<VariablesType> 	Merge
	RequiredBase 		<RequiredBaseType> 	Merge
	Requirements 		<RequirementsType> 	Merge
	Languages 		<LanguagesType> 	Merge
	Completion 		<CompletionType> 	Merge
	LocalizationBase 		<RequiredBaseType> 	Merge
	ResultingResource 		<ResultingResourceType> 	Yes
	Artifacts 		<InstallationArtifactsType> 	No
	any 		namespace="##other" 	 ?  
	*/

		LocalizationUnit finallu = unit1;
		finallu.setIdentityData(IdentityType.merge(unit1.getIdentityData(),unit2.getIdentityData()));
		finallu.setConditionalDerivedVariables(ConditionalDerivedVariablesType.merge(unit1.getConditionalDerivedVariables(), unit2.getConditionalDerivedVariables()));
		finallu.setDerivedVariables(DerivedVariableType.merge(unit1.getDerivedVariables(), unit2.getDerivedVariables()));
		finallu.setRequiredBase(RequiredBaseType.merge(unit1.getRequiredBase(), unit2.getRequiredBase()));
		finallu.setLanguages(LanguageType.merge(unit1.getLanguages(),unit2.getLanguages()));
		finallu.setCompletion(CompletionType.merge(unit1.getCompletion(), unit2.getCompletion()));
		finallu.setLocalizationBase(RequiredBaseType.merge(unit1.getRequiredBase(), unit2.getRequiredBase()));		
		finallu.setInstallArtifact(ArtifactType.merge(unit1.getInstallArtifact(), unit2.getInstallArtifact()));
		finallu.setUndoArtifact(ArtifactType.merge(unit1.getUndoArtifact(), unit2.getUndoArtifact()));
		finallu.setUninstallArtifact(ArtifactType.merge(unit1.getInstallArtifact(), unit2.getInstallArtifact()));
		finallu.setUpdateArtifact(ArtifactType.merge(unit1.getInstallArtifact(), unit2.getInstallArtifact()));
		return null;
	}
	
	public static boolean equals(LocalizationUnit unit1, LocalizationUnit unit2)
	{
		
			if (ResourceType.equals(Util.resolveResourceRef(unit1.getTargetResourceReference()),Util.resolveResourceRef(unit2.getTargetResourceReference())))
			//TODO add in party to do resultingresources	
			return true;
			else return false;
	}

	public static Collection<LocalizationUnit> merge(Collection<LocalizationUnit> localizationUnits1, Collection<LocalizationUnit> localizationUnits2)
	{
		Collection <LocalizationUnit> localizationUnitsToRemove = new ArrayList <LocalizationUnit> ();
		Iterator <LocalizationUnit> localizationUnitIter1 = localizationUnits1.iterator();		
		//iterate through the localizationUnits
		while (localizationUnitIter1.hasNext())
		{
			LocalizationUnit localizationUnit1 = (LocalizationUnit) localizationUnitIter1.next();
			Iterator <LocalizationUnit> localizationUnitIter2 = localizationUnits2.iterator();
			while (localizationUnitIter2.hasNext())
			{
				LocalizationUnit localizationUnit2 = (LocalizationUnit) localizationUnitIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (localizationUnitsToRemove.contains(localizationUnit2)==false)
				{
					if (equals(localizationUnit1, localizationUnit2))
					{  //merge hosted localizationUnits, types and description groups
						localizationUnitsToRemove.add(localizationUnit2);
						
						
						localizationUnit1 = merge(localizationUnit1,localizationUnit2);
						
					}
				}
					
			}
		}
		
		localizationUnits2.removeAll(localizationUnitsToRemove);
		//remove all of the matches that were found
		
		Collection <LocalizationUnit> finalLocalizationUnits = new ArrayList <LocalizationUnit> ();
		//create and return a new collection with all of the remaining items
		finalLocalizationUnits.addAll(localizationUnits1);
		finalLocalizationUnits.addAll(localizationUnits2);		
		
		return finalLocalizationUnits;
	}
	
}
