/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;



public class OutputVariableType {

	public static Collection <OutputVariable> merge(Collection <OutputVariable> outputVariables1, Collection <OutputVariable> outputVariables2)
	{
		// set to hold all the merged variables
		Collection <OutputVariable> outputVariablesToRemove = new ArrayList <OutputVariable> ();
		Iterator <OutputVariable> outputVariableIter1 = outputVariables1.iterator();		
		//iterate through the outputVariables
		while (outputVariableIter1.hasNext())
		{
			OutputVariable outputVariable1 = (OutputVariable) outputVariableIter1.next();
			Iterator <OutputVariable> outputVariableIter2 = outputVariables2.iterator();
			while (outputVariableIter2.hasNext())
			{
				OutputVariable outputVariable2 = (OutputVariable) outputVariableIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (outputVariablesToRemove.contains(outputVariable2)==false)
				{
					if (equals(outputVariable1, outputVariable2))
					{  //merge hosted outputVariables, types and description outputVariables
						outputVariablesToRemove.add(outputVariable2);						
						outputVariable1 = merge(outputVariable1,outputVariable2);						
					}
				}
					
			}
		}
		
		outputVariables2.removeAll(outputVariablesToRemove);
		//remove all of the matches that were found
		
		Collection <OutputVariable> finalOutputVariables = new ArrayList <OutputVariable> ();
		//create and return a new collection with all of the remaining items
		finalOutputVariables.addAll(outputVariables1);
		finalOutputVariables.addAll(outputVariables2);		
		
		return finalOutputVariables;
		
	}
	
	private static OutputVariable merge(OutputVariable outputVariable1, OutputVariable outputVariable2)
	{		
		return outputVariable1;
	}

	public static boolean equals(OutputVariable outputVariable1, OutputVariable outputVariable2)
	{
		if ((outputVariable1.getOutputParameterName()!=null)&&(outputVariable2.getOutputParameterName()==null))
			return false;
		if ((outputVariable2.getOutputParameterName()!=null)&&(outputVariable1.getOutputParameterName()==null))
			return false;
		if ((outputVariable2.getOutputParameterName()!=null)&&(outputVariable1.getOutputParameterName()!=null))
		{
			if (!StringType.equals(outputVariable1.getOutputParameterName(),outputVariable2.getOutputParameterName()))
				return false;
		}
		return true;
		
	}
	
}
