/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;

public class PackageFeatureReferenceType {
	/*
	  <PackageFeatureReferenceType>

	  <xsd:complexType name="PackageFeatureReferenceType">
	    <xsd:attribute name="contentElementRef" type="xsd:IDREF" use="required"/>
	    <xsd:attribute name="packageFeatureRef" type="xsd:NCName" use="required"/>
	    <xsd:anyAttribute namespace="##other" processContents="lax"/>
	  </xsd:complexType>

	  Type 	Element 	Attribute 	Data Type 	Compare?
	  <PackageFeatureReferenceType> 				
	  		contentElementRef 	xsd:IDREF 	Yes
	  		packageFeatureRef 	xsd:NCName 	Yes
	  		any 	namespace="##other" 	 ? 
	
	*/
	public static Collection <PackageFeatureReference> merge (Collection <PackageFeatureReference> packageFeatureReferences1, Collection <PackageFeatureReference> packageFeatureReferences2)
	{
		// set to hold all the merged variables
		Collection <PackageFeatureReference> packageFeatureReferencesToRemove = new ArrayList <PackageFeatureReference> ();
		Iterator <PackageFeatureReference> packageFeatureReferenceIter1 = packageFeatureReferences1.iterator();		
		//iterate through the packageFeatureReferences
		while (packageFeatureReferenceIter1.hasNext())
		{
			PackageFeatureReference packageFeatureReference1 = (PackageFeatureReference) packageFeatureReferenceIter1.next();
			Iterator <PackageFeatureReference> packageFeatureReferenceIter2 = packageFeatureReferences2.iterator();
			while (packageFeatureReferenceIter2.hasNext())
			{
				PackageFeatureReference packageFeatureReference2 = (PackageFeatureReference) packageFeatureReferenceIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (packageFeatureReferencesToRemove.contains(packageFeatureReference2)==false)
				{
					if (equals(packageFeatureReference1, packageFeatureReference2))
					{  //merge hosted packageFeatureReferences, types and description packageFeatureReferences
						packageFeatureReferencesToRemove.add(packageFeatureReference2);						
						packageFeatureReference1 = merge(packageFeatureReference1,packageFeatureReference2);						
					}
				}
					
			}
		}
		
		packageFeatureReferences2.removeAll(packageFeatureReferencesToRemove);
		//remove all of the matches that were found
		
		Collection <PackageFeatureReference> finalPackageFeatureReferences = new ArrayList <PackageFeatureReference> ();
		//create and return a new collection with all of the remaining items
		finalPackageFeatureReferences.addAll(packageFeatureReferences1);
		finalPackageFeatureReferences.addAll(packageFeatureReferences2);		
		
		return finalPackageFeatureReferences;
		
	}
	
	private static PackageFeatureReference merge(PackageFeatureReference packageFeatureReference1, PackageFeatureReference packageFeatureReference2)
	{		
		return packageFeatureReference1;
	}

	public static boolean equals( PackageFeatureReference ref1, PackageFeatureReference ref2)
	{
		try
		{
		if (ContentType.equals(Util.resolveContentRef(ref1.getContentElementRef()),Util.resolveContentRef(ref2.getContentElementRef())))
			//TODO add resolvePackageFeatureRef to Util
			//if (ContentType.equals(Util.resolvePackageFeatureRef(ref1.getPackageFeatureRef()),Util.resolveContentRef(ref2.getPackageFeatureRef())))
				return true;		
		}
		catch (NullPointerException e)
		{
			System.out.println("PackageFeatureReference missing either contentRef or FeatureRef"+e.getMessage());
		}
		return false;
	}

}
