/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class RequirementType {

	public static Collection<Requirement> merge(Collection<Requirement> requirements1, Collection<Requirement> requirements2)
	{	
		Collection <Requirement> requirementsToRemove = new ArrayList <Requirement> ();
		Iterator <Requirement> requirementIter1 = requirements1.iterator();		
		//iterate through the requirements
		while (requirementIter1.hasNext())
		{
			Requirement requirement1 = (Requirement) requirementIter1.next();
			Iterator <Requirement> requirementIter2 = requirements2.iterator();
			while (requirementIter2.hasNext())
			{
				Requirement requirement2 = (Requirement) requirementIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (requirementsToRemove.contains(requirement2)==false)
				{
					if (equals(requirement1, requirement2))
					{  //merge hosted requirements, types and description groups
						requirementsToRemove.add(requirement2);						
						requirement1 = merge(requirement1,requirement2);
						
					}
				}
					
			}
		}
		
		requirements2.removeAll(requirementsToRemove);
		//remove all of the matches that were found
		
		Collection <Requirement> finalRequirements = new ArrayList <Requirement> ();
		//create and return a new collection with all of the remaining items
		finalRequirements.addAll(requirements1);
		finalRequirements.addAll(requirements2);		
		
		return finalRequirements;
		
	}
	
	public static Requirement merge(Requirement requirement1, Requirement requirement2)
	{
		
		requirement1.setDescription(TranslatableStringType.merge(requirement1.getDescription(),requirement2.getDescription()));
		requirement1.setDisplayName(TranslatableStringType.merge(requirement1.getDisplayName(),requirement2.getDisplayName()));
		requirement1.setShortDescription(TranslatableStringType.merge(requirement1.getShortDescription(),requirement2.getShortDescription()));
		
		requirement1.setAlternativeRequirements(AlternativeRequirementType.merge(requirement1.getAlternativeRequirements(), requirement2.getAlternativeRequirements()));
		
		return requirement1;	
	}

	public static boolean equals(Requirement requirement1, Requirement requirement2)
	{
		
		
		if (requirement1.getOperations().size()!=requirement2.getOperations().size())
			return false;
		else
	    {
		    Iterator<String> operationIter1 = requirement1.getOperations().iterator();
		    while (operationIter1.hasNext())
		    {			    	
				Iterator<String> operationIter2 = requirement2.getOperations().iterator();
				String operation1 = operationIter1.next();
				boolean foundEquals = false;
				while ((!foundEquals)&&(operationIter2.hasNext()))
				{
				   if (StringType.equals(operation1,operationIter2.next()))
					   foundEquals = true;					  
				}
				if (!foundEquals)
				   return false;
		    }
	    }
		
		
	    
	    if (requirement1.getResourceConstraints().size()!=requirement2.getResourceConstraints().size())
	    	return false;
	    else
	    {
		    Iterator<RequirementResourceConstraint> constraintIter1 = requirement1.getResourceConstraints().iterator();
		    while (constraintIter1.hasNext())
		    {			    	
				Iterator<RequirementResourceConstraint> constraintIter2 = requirement2.getResourceConstraints().iterator();
				RequirementResourceConstraint constraint1 = constraintIter1.next();
				boolean foundEquals = false;
				while ((!foundEquals)&&(constraintIter2.hasNext()))
				{
				   if (RequirementResourceConstraintType.equals(constraint1,constraintIter2.next()))
					   foundEquals = true;					  
				}
				if (!foundEquals)
				   return false;
		    }
	    }
	    
	    
		//TODO couldn't get out "dependency"  ?
		return true;
		
		
	}
}





















