/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraintValue;

public class VersionConstraintValueType {
	public static VersionConstraintValue merge(VersionConstraintValue versionConstraintValue1, VersionConstraintValue versionConstraintValue2){
		//merges the two version constraint values, first merging the version values then merging the version ranges
		
		Collection<VersionValue> finalVersionValues = mergeValues(versionConstraintValue1.getValues(),versionConstraintValue2.getValues());
		
		Collection<VersionRange> finalVersionRanges = mergeRanges(versionConstraintValue1.getRanges(),versionConstraintValue2.getRanges());

		versionConstraintValue2.setValue(finalVersionValues);
		versionConstraintValue1.setRange(finalVersionRanges);
		
		return versionConstraintValue1;
		
	}
	
	public static Collection<VersionValue> mergeValues(Collection<VersionValue> versionValues1, Collection<VersionValue> versionValues2){
		//merges two version value collections
		
		Collection<VersionValue> duplicates = new ArrayList<VersionValue>();
		Collection<VersionValue> finalVersionValues = new ArrayList<VersionValue>();

		Iterator<VersionValue> versionValuesIter1 = versionValues1.iterator();		
		
		while (versionValuesIter1.hasNext())
		{
			VersionValue versionValue1 = versionValuesIter1.next();
			Iterator<VersionValue> versionValuesIter2 = versionValues2.iterator();
			while (versionValuesIter2.hasNext())
			{
				VersionValue versionValue2 = versionValuesIter2.next();
				
				if (VersionValueType.equals(versionValue1, versionValue2))
				{
					duplicates.add(versionValue2);
				}
					
			}
		}
		
		versionValues2.removeAll(duplicates);
		finalVersionValues.addAll(versionValues1);
		finalVersionValues.addAll(versionValues2);	
		
		return finalVersionValues;
		
	}
	
	public static Collection<VersionRange> mergeRanges(Collection<VersionRange> versionRanges1, Collection<VersionRange> versionRanges2){
		//merges two version value collections
		
		Collection<VersionRange> duplicates = new ArrayList<VersionRange>();
		Collection<VersionRange> finalVersionRanges = new ArrayList<VersionRange>();

		Iterator<VersionRange> versionRangesIter1 = versionRanges1.iterator();		
		
		while (versionRangesIter1.hasNext())
		{
			VersionRange versionRange1 = versionRangesIter1.next();
			Iterator<VersionRange> versionRangesIter2 = versionRanges2.iterator();
			while (versionRangesIter2.hasNext())
			{
				VersionRange versionRange2 = versionRangesIter2.next();
				
				if (VersionRangeType.equals(versionRange1, versionRange2))
				{
					duplicates.add(versionRange2);
				}
					
			}
		}
		
		versionRanges2.removeAll(duplicates);
		finalVersionRanges.addAll(versionRanges1);
		finalVersionRanges.addAll(versionRanges2);
		
		return finalVersionRanges;
		
	}

}
