/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg;
 
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllTests {
	public static final String FSEP = System.getProperty("file.separator");
	public static final String PROPERTYFILE_LOCATION = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "tests" + FSEP + "artifacts" + FSEP + "tooling" + FSEP + "btg";
	// Example ini and sdd Files
	public static final String VALID_PROP = PROPERTYFILE_LOCATION + FSEP + "Valid_btg.ini";
	public static final String VALID_DDFILE = PROPERTYFILE_LOCATION + FSEP + "Valid_DD_Example.xml";
	public static final String VALID_PDFILE = PROPERTYFILE_LOCATION + FSEP + "Valid_PD_Example.xml";
	public static final String INVALID_DDFILE = PROPERTYFILE_LOCATION + FSEP + "Invalid_DD_Example.xml";
	public static final String INVALID_PDFILE = PROPERTYFILE_LOCATION + FSEP + "Invalid_PD_Example.xml";
	public static final String VALID_PDFILE2 = PROPERTYFILE_LOCATION + FSEP + "Valid_PD_Example2.xml";
	public static final String VALID_DDFILE2 = PROPERTYFILE_LOCATION + FSEP + "Valid_DD_Example2.xml";
	
	public static final String NO_BTG_PROP = PROPERTYFILE_LOCATION + FSEP + "No_BTG_Plugin_Prop.ini";
	public static final String INVALID_BTG_ID = PROPERTYFILE_LOCATION + FSEP + "Invalid_Plugin_ID.ini";
	public static final String BTG_NO_OUTPUTFILENAMEBASEVALUE = PROPERTYFILE_LOCATION + FSEP + "BTG_No_OutputFileNameBase_Value.ini";
	public static final String BTG_NO_OUTPUTFILENAMEBASE = PROPERTYFILE_LOCATION + FSEP + "BTG_No_OutputFileNameBase.ini";
	public static final String BTG_DUPLICATE_PROPERTIES = PROPERTYFILE_LOCATION + FSEP + "BTG_Duplicate_Properties.ini";
	public static final String UNKNOWN_PLUGIN_ID = PROPERTYFILE_LOCATION + FSEP + "Unknown_Plugin_ID.ini";
	public static final String BTG_UNSUPPORTED_PROP_ENABLED = PROPERTYFILE_LOCATION + FSEP + "BTG_Unsupported_Property_Enabled.ini";
	public static final String BTG_UNSUPPORTED_PROP_OTHER = PROPERTYFILE_LOCATION + FSEP + "BTG_Unsupported_Property_Other.ini";
	
	public static final String INVALID_PROP_SYNTAX = PROPERTYFILE_LOCATION + FSEP + "Invalid_Property_Syntax.ini";
	public static final String INVALID_PROP_SYNTAX2 = PROPERTYFILE_LOCATION + FSEP + "Invalid_Property_Syntax2.ini";
	public static final String INVALID_PROP_SYNTAX3 = PROPERTYFILE_LOCATION + FSEP + "Invalid_Property_Syntax3.ini";
	public static final String DUPLICATE_PROPERTY_IN_SECTION = PROPERTYFILE_LOCATION + FSEP + "Duplicate_Prop_In_Section.ini";
	public static final String INVALID_FIRST_LINE = PROPERTYFILE_LOCATION + FSEP + "Invalid_First_Line.ini";
	
	public static final String INVALID_NO_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "Invalid_No_Property.ini";
	public static final String RPM_NO_ENABLED_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "RPM_No_Enabled_Prop.ini";
	public static final String RPM_NO_FILENAME_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "RPM_No_FileName_Prop.ini";
	public static final String AGGREGATOR_NO_ENABLED_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "Aggregator_No_Enabled_Prop.ini";
	public static final String AGGREGATOR_NO_RULELOCATION_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "Aggregator_No_RuleLocation_Prop.ini";
	public static final String SDDREADER_NO_ENABLED_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "SDDReader_No_Enabled_Prop.ini";
	public static final String SDDREADER_NO_FILENAME_PROPERTY = PROPERTYFILE_LOCATION + FSEP + "SDDReader_No_FileName_Prop.ini";
	public static final String LAST_SECTION_NO_PROPERTIES = PROPERTYFILE_LOCATION + FSEP + "Last_Section_No_Properties.ini";
	public static final String VALID_ONE_PLUGIN_ENABLED = PROPERTYFILE_LOCATION + FSEP + "Valid_One_Plugin_Enabled.ini";
	
	public static final String BTG_SECTION_ONLY = PROPERTYFILE_LOCATION + FSEP + "BTG_Section_Only.ini";
	public static Test suite() {
		TestSuite suite = new TestSuite(
				"Test for SDD Build Time Generator");
		//$JUnit-BEGIN$
		suite.addTestSuite(BTG_Test.class);
		suite.addTestSuite(PropertiesReader_Test.class);
		//$JUnit-END$
		return suite;
	}

}
