/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.validation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.util.ValidatorUtils;

import junit.framework.Test;
import junit.framework.TestSuite;


public class AllTests {
	public static final String FSEP = System.getProperty("file.separator");
	public static final String ARTIFACT_LOCATION = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "tests" + FSEP + "artifacts" + FSEP + "common" + FSEP + "validation";
	
	// Example XML Files
	public static final String VALID_DD = ARTIFACT_LOCATION + FSEP + "Valid_DD_Example.xml";
	public static final String INVALID_DD = ARTIFACT_LOCATION + FSEP + "Invalid_DD_Example.xml";
	public static final String VALID_PD = ARTIFACT_LOCATION + FSEP + "Valid_PD_Example.xml";
	public static final String INVALID_PD = ARTIFACT_LOCATION + FSEP + "Invalid_PD_Example.xml";
	public static final String MALFORMED_DD = ARTIFACT_LOCATION + FSEP + "Malformed_DD_Example.xml";
	public static final String NON_SDD_XML = ARTIFACT_LOCATION + FSEP + "Non_SDD.xml";
	
	public static final String DD_SCHEMA = "sdd_schema/sdd-deploymentDescriptor-1.0.xsd";
	public static final String PD_SCHEMA = "sdd_schema/sdd-packageDescriptor-1.0.xsd";
	public static final String COMMON_SCHEMA = "sdd_schema/sdd-common-1.0.xsd";
	public static final String XMLDSIG_SCHEMA = "sdd_schema/xmldsig-core-schema.xsd";
	
	
	public static void copySchemaFiles() {
		try {

			// Copy over the SDD Schema files to the test artifacts package
			// Copy the Deployment Descriptor Schema
			FileChannel ddSrcChannel = 
				new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-deploymentDescriptor-1.0.xsd")).getChannel();
			FileChannel ddDestChannel = new FileOutputStream(DD_SCHEMA).getChannel();
			ddDestChannel.transferFrom(ddSrcChannel, 0, ddSrcChannel.size());
			
			// Copy the Package Descriptor Schema
			FileChannel pdSrcChannel = 
				new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-packageDescriptor-1.0.xsd")).getChannel();
			FileChannel pdDestChannel = new FileOutputStream(PD_SCHEMA).getChannel();
			pdDestChannel.transferFrom(pdSrcChannel, 0, pdSrcChannel.size());

			// Copy the Common Schema
			FileChannel commonSrcChannel = 
				new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-common-1.0.xsd")).getChannel();
			FileChannel commonDestChannel = new FileOutputStream(COMMON_SCHEMA).getChannel();
			commonDestChannel.transferFrom(commonSrcChannel, 0, commonSrcChannel.size());
			
			// Copy the xmldsig Schema
			FileChannel xmldsigSrcChannel = 
				new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("xmldsig-core-schema.xsd")).getChannel();
			FileChannel xmldsigDestChannel = new FileOutputStream(XMLDSIG_SCHEMA).getChannel();
			xmldsigDestChannel.transferFrom(xmldsigSrcChannel, 0, xmldsigSrcChannel.size());
			
		} catch (FileNotFoundException e) {

		} catch (IOException e) {
			
		}
	}

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for SDD Validator");
		//$JUnit-BEGIN$
		suite.addTestSuite(XML_DASImpl_Test.class);
		suite.addTestSuite(SchemaValidationRule_Test.class);
		suite.addTestSuite(SchematronValidationRule_Test.class);
		suite.addTestSuite(SDDManagerImpl_Test.class);
		suite.addTestSuite(SDD_DASImpl_Test.class);
		//$JUnit-END$
		return suite;
	}

}
