/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.SchematronValidationRule;


public class SchematronValidationRule_Test extends TestCase {
	private static String FSEP = System.getProperty("file.separator");

	// Schematron files
	private static final String VALID_DD_SCHEMATRON = AllTests.ARTIFACT_LOCATION + FSEP + "Valid_SchematronRules_DD.sch";
	private static final String VALID_PD_SCHEMATRON = AllTests.ARTIFACT_LOCATION + FSEP + "Valid_SchematronRules_PD.sch";
	private static final String INVALID_SCHEMATRON = AllTests.ARTIFACT_LOCATION + FSEP + "Invalid_SchematronRules.sch";
	
	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * Test constructor
	 */
	// Tests creating an instance given existing, readable Rules and Skeleton files
	public void testSchematronValidationRule_ExistingFiles() throws FileNotFoundException, IOException {
		File rulesFile = new File(VALID_DD_SCHEMATRON);
		
		SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
		
		assertNotNull(validationRule);
	}

	// Tests creating an instance given an existing, readable Skeleton file and a missing Rules file
	public void testSchematronValidationRule_MissingRules() throws IOException {
		File rulesFile = new File(AllTests.ARTIFACT_LOCATION + FSEP + "Valid_SchematronRules.sch-NotHere");
		
		try {
			SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
			
			fail("Schemetron rules file is missing but FileNotFoundException was not thrown");
		}
		catch (FileNotFoundException e) {
			// This exception is expected
		}
	}
	

	/*
	 * Test validation
	 */
	// Test validating with Rules that are valid against a valid Deployment Descriptor
	public void testValidate_ValidDD() throws FileNotFoundException, IOException {
		File rulesFile = new File(VALID_DD_SCHEMATRON);
		
		SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
		
		File xmlFile = new File(AllTests.VALID_DD);
		
		assertEquals(validationRule.validate(new FileInputStream(xmlFile)).size(), 0);
	}

	// Test validating with Rules that are valid against a valid Package Descriptor
	public void testValidate_ValidPD() throws FileNotFoundException, IOException {
		File rulesFile = new File(VALID_PD_SCHEMATRON);
		
		SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
		
		File xmlFile = new File(AllTests.VALID_PD);
		
		assertEquals(validationRule.validate(new FileInputStream(xmlFile)).size(), 0);
	}

	// Test validating with Rules that are not valid against a valid Deployment Descriptor
	public void testValidate_InvalidSchematron() throws FileNotFoundException, IOException {
		File rulesFile = new File(INVALID_SCHEMATRON);
		
		SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
		
		File xmlFile = new File(AllTests.VALID_DD);
		
		assertFalse(validationRule.validate(new FileInputStream(xmlFile)).size() == 0);
	}
}