/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation;

import java.io.InputStream;
import java.util.Collection;



/**
 * 
 * @author Eric S. Rose (esrose@us.ibm.com)
 *
 */
public interface ValidationRule {
	/**
	 * This method can perform whatever validation the implementer desires.
	 * 
	 * @param xmlStream InputStream representing XML to be validated
	 * 
	 * @return A Collection of XMLValidationErrors, which is empty if no error occurred
	 */
	Collection<XMLValidationError> validate(InputStream xmlStream);
}
