/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public abstract class DisplayNameableObject extends DescribableObject implements DisplayNameable {
	
	public DisplayNameableObject(Element element, SPISessionImpl session, String sddSchemaType) {
		super(element, session, sddSchemaType);
	}

	public TranslatableString getDisplayName() {
		TranslatableString ts = null;
		
		if (isSetElement("DisplayName")) {
			Element nameElement = getChild("DisplayName");
		    ts = new TranslatableString(nameElement);
		}

		return ts;
	}
	
	public void setDisplayName(TranslatableString displayName) {
		if (displayName == null) {
		    unSetElement("DisplayName");
		}
		else {
            Element element = session.createCommonElement("DisplayName");
            element.setAttribute("translationKey", displayName.getTranslationKey());
            element.setTextContent(displayName.getValue());
			
		    setContent(element);
		}
	}


	public String toString() {
		String tmp = "DisplayName - ";
		
		TranslatableString displayName = getDisplayName();
		if (displayName != null) {
			tmp = displayName.getValue() + "\n";
		}
		else {
			tmp = "(Not set)\n";
		}

		return tmp + super.toString();
	}
}
