/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class FixIdentityImpl extends DescribableObject implements FixIdentity {
	private static final String FIX_IDENTITY_TYPE = "sdd-common:FixIdentityType";

	public FixIdentityImpl(Element data, SPISessionImpl session) {
		super(data, session, FIX_IDENTITY_TYPE);
	}
	
	public String getFixName() {
		String fixName = null;
		
		if (isSetElement("Name")) {
			fixName = getChild("Name").getTextContent();
		}
		
		return fixName;
	}

	public Collection<TranslatableString> getSymptoms() {
		Collection<TranslatableString> symptoms = new ArrayList<TranslatableString>();
		
		if (isSetElement("Symptom")) {
			Collection<Element> symptomElements = getChildren("Symptom");
			
			for (Element symptom : symptomElements) {
				symptoms.add(new TranslatableString(symptom));
			}
		}
		
		return symptoms;
	}

	public void setFixName(String fixName) {
		session.testParameter(fixName, 1, null);
		
		if (fixName == null) {
			unSetElement("Name");
		}
		else {
			Element fixNameElement = session.createCommonElement("Name");
			fixNameElement.setTextContent(fixName);
			
			setContent(fixNameElement);
		}
	}

	public void setSymptoms(Collection<TranslatableString> symptoms) {
		// TODO error-check input
		if (symptoms == null) {
			unSetElement("Symptom");
		}
		else {
			Collection<Element> symptomElements = new ArrayList<Element>();
			removeContent(getChildren("Symptom", false));
			
			for (TranslatableString symptom : symptoms) {
				Element element = session.createCommonElement("Symptom");
				element.setTextContent(symptom.getValue());
				element.setAttribute("translationKey", symptom.getTranslationKey());
				
				symptomElements.add(element);
			}
			
			addContent(symptomElements);
		}
	}

	public Object clone() {
		return new FixIdentityImpl((Element)getElement().cloneNode(true), session);
	}
	
	public String toString() {
		String fixIdentityContents = new String("Fix name: " + getFixName() + "\n" + super.toString());
		
		Collection<TranslatableString> symptoms = getSymptoms();
		
		if (symptoms.size() > 0) {
			fixIdentityContents += "Symptoms:\n";
			for (TranslatableString symptom : symptoms) {
			    fixIdentityContents += " - \"" + symptom.getValue() + "\"\n";
            }
		}
		
		return fixIdentityContents;
	}
}
