/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class Location extends SPIDataObject {
	private static final String LOCATION_TYPE = "sdd-common:LocationType";

	public Location(Element data, SPISessionImpl session) {
		super(data, session, LOCATION_TYPE);
	}
	
	public TranslatableString getAddress() {
		TranslatableString address = null;
		
		if (isSetElement("Address")) {
			address = new TranslatableString(getChild("Address"));
		}
		
		return address;
	}
	
	public TranslatableString getCountry() {
		TranslatableString country = null;
		
		if (isSetAttribute("Country")) {
			country = new TranslatableString(getChild("Country"));
		}
		
		return country;
	}
	
	public void setAddress(TranslatableString address) {
		if (address != null) {
            Element element = session.createCommonElement("Address");
            element.setAttribute("translationKey", address.getTranslationKey());
            element.setTextContent(address.getValue());

			setContent(element);
		}
		else {
			unSetElement("Address");
		}
	}
	
	public void setCountry(TranslatableString country) {
		if (country != null) {
	            Element element = session.createCommonElement("Country");
            element.setAttribute("translationKey", country.getTranslationKey());
            element.setTextContent(country.getValue());

            setContent(element);
		}
		else {
			unSetElement("Country");
		}
	}
	
	public boolean isSetAddress() {
		return isSetElement("Address");
	}
	
	public boolean isSetCountry() {
		return isSetElement("Country");
	}
}