/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.w3c.dom.Element;

public class ManufacturerInformationImpl extends SPIDataObject implements ManufacturerInformation {
	private static final String MANUFACTURER_INFORMATION_TYPE = "sdd-common:ManufacturerType";

	public ManufacturerInformationImpl(Element data, SPISessionImpl session) {
		super(data, session, MANUFACTURER_INFORMATION_TYPE);
	}

	public TranslatableString getAddress() {
		TranslatableString address = null;
		
		if (isSetElement("Location")) {
			Location location = new Location(getChild("Location"), session);
			
			if (location.isSetAddress()) {
				address = location.getAddress();
			}
		}

		return address;
	}

	public TranslatableString getContactInformation() {
		TranslatableString contactInfo = null;
		
		if (isSetElement("ContactInformation")) {
			Element contactElement = getChild("ContactInformation");
			contactInfo = new TranslatableString(contactElement);
		}

		return contactInfo;
	}

	public TranslatableString getCountry() {
		TranslatableString country = null;
		
		if (isSetElement("Location")) {
			Location location = new Location(getChild("Location"), session);
			
			if (location.isSetCountry()) {
				country = location.getCountry();
			}
		}
		
		return country;
	}

	public TranslatableString getName() {
		TranslatableString name = null;
		
		if (isSetElement("Name")) {
			Element nameElement = getChild("Name");
			name = new TranslatableString(nameElement);
		}

		return name;
	}

	public void setAddress(TranslatableString address) {
		if (address == null && isSetElement("Location")) {
			Location location = new Location(getChild("Location"), session);
			
			if (!location.isSetCountry()) {
				unSetElement("Location");
			}
			else {
				location.unSetElement("Address");
				setContent(location);
			}
		}
		else if (address != null) {
			Location location = null;
			
			if (isSetElement("Location")) {
				location = new Location(getChild("Location"), session);
			}
			else {
				location = new Location(session.createCommonElement("Location"), session);
			}
			
			location.setAddress(address);
			setContent(location);
		}
	}

	public void setContactInformation(TranslatableString contactInformation) {
		if (contactInformation == null) {
			unSetElement("ContactInformation");
		}
		else {
			Element element = session.createCommonElement("ContactInformation");
			element.setAttribute("translationKey", contactInformation.getTranslationKey());
			element.setTextContent(contactInformation.getValue());

			setContent(element);
		}
	}

	public void setCountry(TranslatableString country) {
		if (country == null && isSetElement("Location")) {
			Location location = new Location(getChild("Location"), session);
			
			if (!location.isSetAddress()) {
				unSetElement("Location");
			}
			else {
				location.unSetElement("Country");
				setContent(location);
			}
		}
		else if (country != null) {
			Location location = null;
			
			if (isSetElement("Location")) {
				location = new Location(getChild("Location"), session);
			}
			else {
				location = new Location(session.createCommonElement("Location"), session);
			}
			
			location.setCountry(country);
			setContent(location);
		}
	}

	public void setName(TranslatableString name) {
		session.testParameter(name, 1, null);
		
		if (name == null) {
			unSetElement("Name");
		}
		else {
            Element element = session.createCommonElement("Name");
            element.setAttribute("translationKey", name.getTranslationKey());
            element.setTextContent(name.getValue());

			setContent(element);
		}
	}
	
	public Object clone() {
		return new ManufacturerInformationImpl((Element)getElement().cloneNode(true), session);
	}
}