/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.math.BigInteger;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig.DigestMethodImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.DigestMethod;
import org.w3c.dom.Element;


public class PackageContentImpl extends SPIDataObject implements PackageContent, Cloneable {
	private static final String PACKAGE_CONTENT_TYPE = "sdd-pd:ContentType";
    
	public PackageContentImpl(Element data, SPISessionImpl session) {
		super(data, session, PACKAGE_CONTENT_TYPE);
	}
	
	public String getContentID() {
   		return getAttribute("id");
    }

	public String getContentPurpose() {
   		return getAttribute("purpose");
	}

	public String getPathname() {
   		return getAttribute("pathname");
	}	
	
	public String getCharEncoding() {
   		return getAttribute("charEncoding");
	}

	public BigInteger getLength() {
    	if (isSetAttribute("length")) {
    		String lengthString = getAttribute("length");
    		return new BigInteger(lengthString);
    	}
    	else {
    		return null;
    	}
	}

	public DigestMethod getDigestMethod() {
		DigestMethod digestMethod = null;
		
		if (isSetElement("DigestMethod")) {
			digestMethod = new DigestMethodImpl(getChild("DigestMethod"), session);
		}
		
		return digestMethod;
	}

	public byte[] getDigestValue() {
		byte[] digestValue = null;
		
		if (isSetElement("DigestValue")) {
			digestValue = getChild("DigestValue").getTextContent().getBytes();
		}
		
		return digestValue;
	}
	
	public void setContentID(String contentID) {
		session.testParameter(contentID, 1, null);
		
		setAttribute("id", contentID);	
	}

	public void setContentPurpose(String contentPurpose) {
		// TODO error check input
		setAttribute("purpose", contentPurpose);	
	}

	public void setPathname(String pathname) {
		session.testParameter(pathname, 1, null);

		setAttribute("pathname", pathname);	
	}
	
	public void setCharEncoding(String charEncoding) {
		setAttribute("charEncoding", charEncoding);	
	}

	public void setLength(BigInteger length) {
		if (length != null) {
			String lengthString = length.toString();
			setAttribute("length", lengthString);	
		}
		else {
			unSetAttribute("length");
		}		
	}

	public void setDigest(DigestMethod digestMethod, byte[] digestValue) {
		if (digestMethod == null && digestValue != null) {
			session.testParameter(digestMethod, 1, null);
		}
		if (digestMethod != null && digestValue == null) {
			session.testParameter(digestValue, 2, null);
		}
		
		if (digestMethod == null) {
			unSetElement("DigestMethod");
		}
		else {
			setContent((SPIDataObject)digestMethod);
		}
		
		if (digestValue == null) {
			unSetElement("DigestValue");
		}
		else {
			Element digestValueElement = session.createXmlDsigElement("DigestValue");
			digestValueElement.setTextContent(new String(digestValue));
			setContent(digestValueElement);
		}		
	}

	public Object clone() {
		// TODO this is temporary support for open content
//		Sequence anyAttributes = contentDataObject.getAnyAttribute();
//
//		Property prop;
//		String attValue;
//		for (int i = 0; i < anyAttributes.size(); i++)
//		{
//			prop = anyAttributes.getProperty(i);
//			attValue = ((DataObject)contentDataObject).getString(prop);
//			duplicate.addAttribute(customSchema, customNamespace, prop.getName(), attValue);
//		}
		
		return new PackageContentImpl((Element)getElement().cloneNode(true), session);
	}

	public String toString() {
		String description = new String("ContentID: " + getContentID() + " - Pathname: \"" + getPathname() + "\"");
		
		String contentPurpose = getContentPurpose();
		BigInteger length = getLength();
		
		if (contentPurpose != null) {
			description += " - Purpose: " + contentPurpose;
		}
		
		if (length != null) {
			description += " - Length: " + length;
		}
		
		description += "\n";
		
		return description;
	}
	
//	public void addAttribute(String attName, String attValue)
//	{
//		// TODO This is all temporary...
//
//		String newXmlns = "http://www.ibm.com/isd/spi/openAtt";
//		String newSchema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
//		"<xsd:schema xmlns:open=\"" + newXmlns +
//		"\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"" + newXmlns + "\">" +
//		"<xsd:attribute name=\"" + attName + "\" type=\"xsd:string\"/>" + 
//		"</xsd:schema>";
//
//		addAttribute(newSchema,newXmlns,attName, attValue);
//
//	}
	
//	public void addAttribute(String schema, String namespace, String attName, String attValue)
//	{
//		// TODO This is all temporary...
//		HelperContext hc = SDOUtil.createHelperContext();
//		TypeHelper typeHelper = hc.getTypeHelper();
//		XSDHelper xsdHelper = hc.getXSDHelper();
//        customSchema = schema;
//        customNamespace = namespace;
//
//		xsdHelper.define(schema);
//		Property prop = typeHelper.getOpenContentProperty(namespace, attName);
//		Sequence anyAttributes = contentDataObject.getAnyAttribute();
//		anyAttributes.add(prop, attValue);
//
//	}
}
