/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.RelationshipImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;


public class ResultingResourceMapImpl extends ResourceMapImpl implements ResultingResourceMap {
    private static final String RESULTING_RESOURCE_MAP_TYPE = "sdd-dd:ResultingResourceMapType";
    private static final String RESULTING_PROPERTY_TYPE = "sdd-dd:ResultingPropertyType";
	
    public ResultingResourceMapImpl(Element rrmdo, SPISessionImpl session) {
        super(rrmdo, session, RESULTING_RESOURCE_MAP_TYPE);
    }

    public Collection<String> getFixNames() {
        Collection<String> fixNames = new ArrayList<String>();
        Collection<Element> fixNameElements = getChildren("FixName");

        for (Element fixName : fixNameElements) {
            fixNames.add(fixName.getTextContent());
        }

        return fixNames;
    }

    public String getName() {
    	if (isSetElement("Name")) {
    		Element name = getChild("Name");
    		
    		return name.getTextContent();
    	}
    	else {
    		return null;
    	}
    }

    public Properties getProperties() {
    	Collection<Element> propertyElements = getChildren("Property");
    	Properties properties = new Properties();
    	
    	for (Element propertyElement : propertyElements) 
    	{
    		String propertyName = session.getChild(propertyElement, "PropertyName").getTextContent();
    		String value = session.getChild(propertyElement, "Value").getTextContent();
    		
    		properties.put(propertyName, value);
    	}

        return (Properties)properties;
    }

    public String getVersion() {
    	if (isSetElement("Version")) {
    		Element name = getChild("Version");
    		
    		return name.getTextContent();
    	}
    	else {
    		return null;
    	}
    }

    public void setFixNames(Collection<String> names) {
		removeContent(getChildren("FixName", false));
		Collection<Element> fixNameElements = new ArrayList<Element>();
		
		for (String fixName : names) {
			Element fixNameElement = session.createDeploymentElement("FixName");
			fixNameElement.setTextContent(fixName);
			fixNameElements.add(fixNameElement);
		}
		
		addContent(fixNameElements);    	
    }

    public void setName(String name) {
    	if (name == null) {
    		unSetElement("Name");
    	}
    	else {
           	Element nameElement = session.createDeploymentElement("Name");
           	nameElement.setTextContent(name);
            	
           	setContent(nameElement);
    	}
    }

    public void setProperties(Properties props) {
        // TODO error check input
    	if (props != null) {
    		Collection<Element> properties = new ArrayList<Element>();
    		removeContent(getChildren("Property", false));
    		
    		for (Enumeration<Object> e = props.keys(); e.hasMoreElements(); ) {
    			String key = (String)e.nextElement();
    			String value = props.getProperty(key);
    			
    			Element propertyElement = session.createDeploymentElement("Property");
    			Element propertyNameElement = session.createDeploymentElement("PropertyName");
    			Element valueElement = session.createDeploymentElement("Value");
    			
    			propertyNameElement.setTextContent(key);
    			valueElement.setTextContent(value);
                session.insertNode(propertyElement, propertyNameElement, RESULTING_PROPERTY_TYPE);
                session.insertNode(propertyElement, valueElement, RESULTING_PROPERTY_TYPE);
    			
    			properties.add(propertyElement);
    		}
    		
			addContent(properties);
    	}
    	else {
    		unSetElement("Property");
    	}
    }

    public void setVersion(String version) {
    	if (version == null) {
    		unSetElement("Version");
    	}
    	else {
        	Element versionElement = session.createDeploymentElement("Version");
        	versionElement.setTextContent(version);
        	
        	setContent(versionElement);    		
    	}
    }

    public Object clone() {
        return new ResultingResourceMapImpl((Element)getElement().cloneNode(true), session);
    }

    public Condition getCondition() {
        Condition condition = null;

        if (isSetElement("Condition")) {
        	Element conditionElement = getChild("Condition");

            condition = new ConditionImpl(conditionElement, session);
        }
        
        return condition;
    }

    public void setCondition(Condition condition) {
    	if (condition == null) {
    		unSetElement("Condition");
    	}
    	else {
    		setContent((SPIDataObject)condition);
    	}
    }

    public Collection<Relationship> getRelationships() {
        Collection<Element> relationshipElements = getChildren("Relationship");
        Collection<Relationship> relationships = new ArrayList<Relationship>();
        
        for (Element relationshipElement : relationshipElements) {
            relationships.add(new RelationshipImpl(relationshipElement, session));
        }
        
        return relationships;
    }

    public void setRelationships(Collection<Relationship> relationships) {
        if (relationships != null && !relationships.isEmpty()) {
            removeContent(getChildren("Relationship", false));
            
            addContent(relationships);
        }
        else {
        	unSetElement("Relationship");
        }
    }
}