/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.w3c.dom.Element;

public class AlternativeConditionImpl extends NameableObject implements AlternativeCondition {
	private static final String ALTERNATIVE_CONDITIONAL_TYPE = "sdd-dd:AlternativeConditionalType";

	public AlternativeConditionImpl(Element data, SPISessionImpl session) {
		super(data, session, ALTERNATIVE_CONDITIONAL_TYPE);
	}
	
	public String getAlternativeConditionID() {
		return getAttribute("id");
	}

	public Collection<ConditionalResourceConstraint> getConditionalResourceConstraints() {
		Collection<Element> constraintElements = getChildren("ResourceConstraint");
		Collection<ConditionalResourceConstraint> crcList = new ArrayList<ConditionalResourceConstraint>();
		
		for (Element element : constraintElements) {
			ConditionalResourceConstraint temp = new ConditionalResourceConstraintImpl(element, session);
			crcList.add((ConditionalResourceConstraint)temp);
		}

		return crcList;
	}

	public void setAlternativeConditionID(String id) {
		session.testParameter(id, 1, null);
		
		setAttribute("id", id);
	}

	public void setConditionalResourceConstraints(Collection<ConditionalResourceConstraint> crc) {
		session.testParameter(crc, 1, null);
		
		removeContent(getChildren("ResourceConstraint", false));

		addContent(crc);		
	}
	
	public Object clone() {
		return new AlternativeConditionImpl((Element)getElement().cloneNode(true), session);
	}	
}
