/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.w3c.dom.Element;

// Consider splitting into two classes - with & without alternatives
public class ConditionImpl extends NameableObject implements Condition {
	private static final String CONDITION_TYPE = "sdd-dd:ConditionType";
	
	public ConditionImpl(Element data, SPISessionImpl session) {
		super(data, session, CONDITION_TYPE);
	}

	public Collection<AlternativeCondition> getAlternativeConditions() {
		Collection<Element> alternativeConditionList = getChildren("Alternative");
		
		Collection<AlternativeCondition> alternativeConditions = new ArrayList<AlternativeCondition>();
		
		for (Element element : alternativeConditionList) {
			AlternativeCondition alternativeCondition = new AlternativeConditionImpl(element, session); 
			alternativeConditions.add(alternativeCondition);
		}
		
		return alternativeConditions;
	}

	public Collection<ConditionalResourceConstraint> getConditionalResourceConstraints() {
		Collection<Element> conditionalResourceConstraintList = getChildren("ResourceConstraint");

		Collection<ConditionalResourceConstraint> conditionalResourceConstraints =
			new ArrayList<ConditionalResourceConstraint>();
		
		for (Element element : conditionalResourceConstraintList) {
			ConditionalResourceConstraint crc = new ConditionalResourceConstraintImpl(element, session);
			conditionalResourceConstraints.add(crc);
		}
		
		return conditionalResourceConstraints;
	}

    public Collection<String> getOperations() {
    	String operationList = getAttribute("operation");
    	
    	Collection<String> operations = new ArrayList<String>();
    	
    	if (operationList != null && operationList.length() > 0) {
    		String[] tokens = operationList.split(" ");
    		
    		for (String token : tokens) {
    			operations.add(token);
    		}
    	}

        return operations;
    }

	public void setAlternativeConditions(Collection<AlternativeCondition> alternativeConditions) {		
		// TODO check for null/zero length
		removeContent(getChildren("Alternative", false));
		
		addContent(alternativeConditions);
	}

	public void setConditionalResourceConstraints(Collection<ConditionalResourceConstraint> crc) {
		// TODO check for null/zero length
		removeContent(getChildren("ResourceConstraint", false));
		
		addContent(crc);
	}

    public void setOperations(Collection<String> operations) {
        // TODO check for enum value match 
        if (operations == null || operations.size() == 0) {
            unSetAttribute("operation");
        }
        else {
        	String operationString = "";
        	
        	for (String operation : operations) {
        		operationString += operation + " ";
        	}
        	operationString = operationString.substring(0, operationString.length() - 1);
        	
        	setAttribute("operation", operationString);
        }
    }

	public Object clone() {
		return new ConditionImpl((Element)getElement().cloneNode(true), session);
	}	
}