/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.PropertyValueListImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalPropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;
import org.w3c.dom.Element;

public class ConditionalPropertyConstraintImpl extends DescribableObject implements ConditionalPropertyConstraint {
	private static final String CONDITIONAL_PROPERTY_CONSTRAINT_TYPE = "sdd-dd:ConditionalPropertyConstraintType";
	
	public ConditionalPropertyConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, CONDITIONAL_PROPERTY_CONSTRAINT_TYPE);
	}
			
	public String getPropertyName() {
		String value = null;
		
		if (isSetElement("PropertyName")) {
			value =  getChild("PropertyName").getTextContent();
		}
		
		return value;
	}

	public void setPropertyName(String propertyName) {
		session.testParameter(propertyName, 1, null);
		
		if (propertyName != null) {
			Element propertyNameElement = session.createDeploymentElement("PropertyName");
			propertyNameElement.setTextContent(propertyName);
			setContent(propertyNameElement);
		}
		else {
			unSetElement("PropertyName");
		}
	}
	
	public String getValue() {
		String value = null;
		
		if (isSetElement("Value")) {
			value =  getChild("Value").getTextContent();
		}
				
		return value;
	}

	public void setValue(String value) {
		session.testParameter(value, 1, null);
		
		if (value != null) {
			Element propertyNameElement = session.createDeploymentElement("Value");
			propertyNameElement.setTextContent(value);
			setContent(propertyNameElement);
		}
		else {
			unSetElement("Value");
		}
	}
	
	public PropertyValueList getValueList() {
		PropertyValueList valueList = null;
		
		if (isSetElement("ListOfValues")) {
			Element valueListElement = getChild("ListOfValues");
			valueList = new PropertyValueListImpl(valueListElement, session);
		}
		
		return valueList;
	}
	
	public void setValueList(PropertyValueList values) {
		session.testParameter(values, 1, null);
		
		if (values == null) {
			unSetElement("ListOfValues");
		}
		else {
			setContent(((SPIDataObject)values).getElement());
		}
	}

	public Object clone() {
		return new ConditionalPropertyConstraintImpl((Element)getElement().cloneNode(true), session);
	}
}
