/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.w3c.dom.Element;

public class VersionValueImpl extends SPIDataObject implements VersionValue {
	private static final String VERSION_VALUE_TYPE = "sdd-dd:VersionValueType";

	public VersionValueImpl(Element data, SPISessionImpl session) {
		super(data,session, VERSION_VALUE_TYPE);
	}
	
	public Collection<String> getFixNames() {
		Collection<Element> fixNameElements = getChildren("FixName");
		Collection<String> fixNames = new ArrayList<String>();
		
		for (Element element : fixNameElements) {
			fixNames.add(element.getTextContent());
		}

		return fixNames;
	}

	public String getVersion() {
		if (isSetElement("Version")) {
			return getChild("Version").getTextContent();
		}
		else {
			return null;
		}
	}

	public void setFixNames(Collection<String> fixNames) {
		removeContent(getChildren("FixName", false));
		Collection<Element> fixNameElements = new ArrayList<Element>();
		
		for (String fixName : fixNames) {
			Element fixNameElement = session.createDeploymentElement("FixName");
			fixNameElement.setTextContent(fixName);
			fixNameElements.add(fixNameElement);
		}
		
		addContent(fixNameElements);
	}

	public void setVersion(String version) {
		session.testParameter(version, 1, null);
		
		if (version != null) {
			Element versionElement = session.createDeploymentElement("Version");
			versionElement.setTextContent(version);
		
			setContent(versionElement);
		}
		else {
			unSetElement("Version");
		}
	}

	public Object clone() {
		return new VersionValueImpl((Element)getElement().cloneNode(true), session); 
	}	
}