/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;

public class CompositeLocalizationUnitImpl extends ContentUnitImpl implements CompositeLocalizationUnit {
	private static final String COMPOSITE_LOCALIZATION_UNIT_TYPE = "sdd-dd:CompositeLocalizationUnitType";
	private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";
	private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
	
    public CompositeLocalizationUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, COMPOSITE_LOCALIZATION_UNIT_TYPE);
    }

    public Collection<Completion> getCompletions() {
    	Collection<Element> completionElements = getChildren("Completion");
        Collection<Completion> completions = new ArrayList<Completion>();

        for (Element element : completionElements) {
            completions.add(new CompletionImpl(element, session));
        }

        return completions;
    }

    public Collection<CompositeLocalizationUnit> getCompositeLocalizationUnits() {
    	Collection<Element> cluElements = getChildren("CompositeLocalizationUnit");
        Collection<CompositeLocalizationUnit> compositeLocalizationUnits = new ArrayList<CompositeLocalizationUnit>();

        for (Element element : cluElements) {
            compositeLocalizationUnits.add(new CompositeLocalizationUnitImpl(element, session));
        }

        return compositeLocalizationUnits;
    }

    public Condition getCondition() {
    	Condition c = null;
        
        if (isSetElement("Condition")) {
            c = new ConditionImpl(getChild("Condition"), session);
        }

        return c;
    }

    public Collection<ReferencedPackage> getContainedLocalizationPackages() {
    	
    	Collection<Element> containedLocalizationPackageElements = getChildren("ContainedLocalizationPackage");
        Collection<ReferencedPackage> containedLocalizationPackages = new ArrayList<ReferencedPackage>();

        for (Element element : containedLocalizationPackageElements) {
            containedLocalizationPackages.add(new ReferencedPackageImpl(element, session));
        }

        return containedLocalizationPackages;
    }

    public RequiredBase getLocalizationBase() {
    	RequiredBase localizationBase = null;
        
        if (isSetElement("LocalizationBase")) {
        	localizationBase = new RequiredBaseImpl(getChild("LocalizationBase"), session);
        }

        return localizationBase;
    }

    public Collection<LocalizationUnit> getLocalizationUnits() {
    	Collection<Element> localizationUnitElements = getChildren("LocalizationUnit");
        Collection<LocalizationUnit> localizationUnits = new ArrayList<LocalizationUnit>();

        for (Element element : localizationUnitElements) {
            localizationUnits.add(new LocalizationUnitImpl(element, session));
        }

        return localizationUnits;
    }

    public RequiredBase getRequiredBase() {
    	RequiredBase requiredBase = null;
        
        if (isSetElement("RequiredBase")) {
        	requiredBase = new RequiredBaseImpl(getChild("RequiredBase"), session);
        }

        return requiredBase;
    }

    public Collection<Requirement> getRequirements() {
    	Collection<Requirement> requirements = new ArrayList<Requirement>();

        if (isSetElement("Requirements")) {
            Collection<Element> requirementElementList = session.getChildren(getChild("Requirements"), "Requirement");

            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, session));
            }
        }
        else {
            requirements = new ArrayList<Requirement>();
        }

        return requirements;
    }

    public Collection<ResultingResource> getResultingResources() {
    	 Collection<Element> resultingResourceElements = getChildren("ResultingResource");
         Collection<ResultingResource> resultingResources = new ArrayList<ResultingResource>();

         for (Element element : resultingResourceElements) {
             resultingResources.add(new ResultingResourceImpl(element, session));
         }

         return resultingResources;
    }

    public Collection<Language> getLanguages() {
    	Collection<Language> languages = new ArrayList<Language>();

        if (isSetElement("Languages")) {
            Collection<Element> languageElementList = session.getChildren(getChild("Languages"), "Language");

            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, session));
            }
        }
        else {
            languages = new ArrayList<Language>();
        }

        return languages;
    }

    public void setCompletions(Collection<Completion> completions) {
    	 if (completions != null && !completions.isEmpty()) {
             //Remove all Completion elements
             removeContent(getChildren("Completion", false));

             addContent(completions);
         }
         else {
             //Remove all Completion elements
             removeContent(getChildren("Completion", false));
         }
    }

    public void setCompositeLocalizationUnits(Collection<CompositeLocalizationUnit> localizationUnits) {
    	session.testParameter(localizationUnits, 1, null);
    	
    	if (localizationUnits != null && !localizationUnits.isEmpty()) {
            //Remove all CompositeLocalizationUnit elements
            removeContent(getChildren("CompositeLocalizationUnit", false));

            addContent(localizationUnits);
        }
        else {
            //Remove all CompositeLocalizationUnit elements
            removeContent(getChildren("CompositeLocalizationUnit", false));
        }    	
    }

    public void setCondition(Condition condition) {
    	if (condition == null) {
            unSetElement("Condition");
        }
        else {
            setContent((SPIDataObject) condition);
        }
    }

    public void setContainedLocalizationPackages(Collection<ReferencedPackage> packages) {
    	if (getLocalizationUnits().isEmpty() && getCompositeLocalizationUnits().isEmpty()) {
            session.testParameter(packages, 1, null);
        }
    	if (packages != null && !packages.isEmpty()) {
            //Remove all ContainedLocalizationPackage elements
            removeContent(getChildren("ContainedLocalizationPackage", false));

            addContent(packages);
        }
        else {
            //Remove all ContainedLocalizationPackage elements
            removeContent(getChildren("ContainedLocalizationPackage", false));
        }
    }

    public void setLocalizationBase(RequiredBase localizationBase) {
    	if (localizationBase == null) {
            unSetElement("LocalizationBase");
        }
        else {
            setContent((SPIDataObject) localizationBase);
        }
    }

    public void setLocalizationUnits(Collection<LocalizationUnit> localizationUnits) {
    	if (getContainedLocalizationPackages().isEmpty() && getCompositeLocalizationUnits().isEmpty()) {
            session.testParameter(localizationUnits, 1, null);
        }
    	
    	if (localizationUnits != null && !localizationUnits.isEmpty()) {
            //Remove all LocalizationUnit elements
            removeContent(getChildren("LocalizationUnit", false));

            addContent(localizationUnits);
        }
        else {
            //Remove all LocalizationUnit elements
            removeContent(getChildren("LocalizationUnit", false));
        }
    }

    public void setRequiredBase(RequiredBase requiredBase) {
    	if (requiredBase == null) {
            unSetElement("RequiredBase");
        }
        else {
            setContent((SPIDataObject) requiredBase);
        }
    }

    public void setRequirements(Collection<Requirement> requirements) {
        if (requirements != null && !requirements.isEmpty()) {
            Element requirementsDataObject;

            if (isSetElement("Requirements")) {
                requirementsDataObject = getChild("Requirements");
            }
            else {
                requirementsDataObject = session.createDeploymentElement("Requirements");
            }

            //Remove all Requirement elements
            Collection<Element> requirementNodeList = session.getChildren(requirementsDataObject, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsDataObject.removeChild(element);
            }
            
            for (Requirement requirement : requirements) {
                session.insertNode(requirementsDataObject, (SPIDataObject) requirement, REQUIREMENTS_TYPE);
            }

            setContent(requirementsDataObject);
        }
        else {
            unSetElement("Requirements");
        }
    }

    public void setResultingResources(Collection<ResultingResource> resources) {
    	if (resources != null && !resources.isEmpty()) {
            //Remove all ResultingResource elements
            removeContent(getChildren("ResultingResource", false));

            addContent(resources);
        }
        else {
            //Remove all ResultingResource elements
            removeContent(getChildren("ResultingResource", false));
        }
    }

    public void setLanguages(Collection<Language> languages) {
    	if (languages != null && !languages.isEmpty()) {
            Element languagesElement;

            if (isSetElement("Languages")) {
                languagesElement = getChild("Languages");
            }
            else {
                languagesElement = session.createDeploymentElement("Languages");
            }

            //Remove all Language elements
            Collection<Element> languageNodeList = session.getChildren(languagesElement, "Language");
            for (Element element : languageNodeList) {
                languagesElement.removeChild(element);
            }
            
            for (Language language : languages) {
                session.insertNode(languagesElement, (SPIDataObject) language, LANGUAGES_TYPE);
            }

            setContent(languagesElement);
        }
        else {
            unSetElement("Languages");
        }
    }

    public Object clone() {
    	return new CompositeLocalizationUnitImpl((Element)getElement().cloneNode(true), session);
    }
}
