/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ReferencedPackageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;

public class CompositeUnitImpl extends ContentUnitImpl implements CompositeUnit {
	private static final String COMPOSITE_UNIT_TYPE = "sdd-dd:CompositeUnitType";
	private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";
	
    public CompositeUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, COMPOSITE_UNIT_TYPE);
    }

    public Collection<CompositeUnit> getCompositeUnits() {
    	Collection<Element> compositeUnitElements = getChildren("CompositeUnit");
        Collection<CompositeUnit> compositeUnits = new ArrayList<CompositeUnit>();

        for (Element element : compositeUnitElements) {
            compositeUnits.add(new CompositeUnitImpl(element, session));
        }

        return compositeUnits;
    }

    public Condition getCondition() {
    	Condition c = null;
        
        if (isSetElement("Condition")) {
            c = new ConditionImpl(getChild("Condition"), session);
        }

        return c;
    }

    public Collection<ConfigurationUnit> getConfigurationUnits() {
    	Collection<Element> configurationUnitElements = getChildren("ConfigurationUnit");
        Collection<ConfigurationUnit> configurationUnit = new ArrayList<ConfigurationUnit>();

        for (Element element : configurationUnitElements) {
            configurationUnit.add(new ConfigurationUnitImpl(element, session));
        }

        return configurationUnit;   
    }

    public Collection<ReferencedPackage> getContainedPackages() {
    	Collection<Element> containedPackageElements = getChildren("ContainedPackage");
        Collection<ReferencedPackage> containedPackages = new ArrayList<ReferencedPackage>();

        for (Element element : containedPackageElements) {
            containedPackages.add(new ReferencedPackageImpl(element, session));
        }

        return containedPackages;
    }

    public Collection<InstallableUnit> getInstallableUnits() {
    	Collection<Element> installableUnitElements = getChildren("InstallableUnit");
        Collection<InstallableUnit> installableUnits = new ArrayList<InstallableUnit>();

        for (Element element : installableUnitElements) {
            installableUnits.add(new InstallableUnitImpl(element, session));
        }

        return installableUnits;
    }

    public Collection<Requirement> getRequirements() {
    	Collection<Requirement> requirements = new ArrayList<Requirement>();

        if (isSetElement("Requirements")) {
            Collection<Element> requirementElementList = session.getChildren(getChild("Requirements"), "Requirement");

            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, session));
            }
        }

        return requirements;
    }

    public void setCompositeUnits(Collection<CompositeUnit> compositeUnits) {
    	if (compositeUnits != null && !compositeUnits.isEmpty()) {
            //Remove all CompositeUnit elements
            removeContent(getChildren("CompositeUnit", false));

            addContent(compositeUnits);
        }
        else {
            //Remove all CompositeUnit elements
            removeContent(getChildren("CompositeUnit", false));
        }
    }

    public void setCondition(Condition condition) {
    	if (condition == null) {
            unSetElement("Condition");
        }
        else {
            setContent((SPIDataObject) condition);
        }
    }

    public void setConfigurationUnits(Collection<ConfigurationUnit> configurationUnits) {
    	if (configurationUnits != null && !configurationUnits.isEmpty()) {
            //Remove all ConfigurationUnit elements
            removeContent(getChildren("ConfigurationUnit", false));

            addContent(configurationUnits);
        }
        else {
            //Remove all ConfigurationUnit elements
            removeContent(getChildren("ConfigurationUnit", false));
        }
    }

    public void setContainedPackages(Collection<ReferencedPackage> containedPackages) {
    	if (containedPackages != null && !containedPackages.isEmpty()) {
            //Remove all ContainedPackage elements
            removeContent(getChildren("ContainedPackage", false));

            addContent(containedPackages);
        }
        else {
            //Remove all ContainedPackage elements
            removeContent(getChildren("ContainedPackage", false));
        }
    }

    public void setInstallableUnits(Collection<InstallableUnit> installableUnits) {
    	if (installableUnits != null && !installableUnits.isEmpty()) {
            //Remove all InstallableUnit elements
            removeContent(getChildren("InstallableUnit", false));

            addContent(installableUnits);
        }
        else {
            //Remove all InstallableUnit elements
            removeContent(getChildren("InstallableUnit", false));
        }
    }

    public void setRequirements(Collection<Requirement> requirements) {
    	if (requirements != null && !requirements.isEmpty()) {
            Element requirementsElement;

            if (isSetElement("Requirements")) {
                requirementsElement = getChild("Requirements");
            }
            else {
                requirementsElement = session.createDeploymentElement("Requirements");
            }

            //Remove all Requirement elements
            Collection<Element> requirementNodeList = session.getChildren(requirementsElement, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsElement.removeChild(element);
            }
            
            for (Requirement requirement : requirements) {
                session.insertNode(requirementsElement, (SPIDataObject) requirement, REQUIREMENTS_TYPE);
            }

            setContent(requirementsElement);
        }
        else {
            unSetElement("Requirements");
        }
    }

    public Object clone() {
    	return new CompositeUnitImpl((Element)getElement().cloneNode(true), session);
        
    }
}
