/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Feature;
import org.w3c.dom.Element;

public class FeatureImpl extends NestedFeatureImpl implements Feature {
	private static final String FEATURE_TYPE = "sdd-dd:FeatureType";
	
    public FeatureImpl(Element data, SPISessionImpl session) {
        super(data, session, FEATURE_TYPE);
    }

    public Boolean getRequired() {
        return new Boolean(getAttribute("required"));
    }

    public void setRequired(Boolean required) {
        if (required == null) {
            unSetAttribute("required");
        }
        else {
            setAttribute("required", required.toString());
        }
    }
    
    public Object clone() {
    	return new FeatureImpl((Element)getElement().cloneNode(true), session);
    }
}
