/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.w3c.dom.Element;

public class GroupImpl extends DisplayNameableObject implements Group {
	private static final String GROUP_TYPE = "sdd-dd:GroupType";
	
    public GroupImpl(Element data, SPISessionImpl session) {
        super(data, session, GROUP_TYPE);
    }

    public Boolean getDefault() {
        return new Boolean(getAttribute("default"));
    }

    public String getGroupID() {
        return getAttribute("id");

    }

    public Collection<String> getSelectedFeatures() {
    	Collection<Element> selectedFeatureElements = getChildren("SelectedFeature");
        Collection<String> features = new ArrayList<String>();

        for (Element element : selectedFeatureElements) {
        	String featureRef = element.getAttribute("featureRef");
        	if (featureRef.length() == 0) {
        		featureRef = null;
        	}
        	
            features.add(featureRef);
        }

        return features;
    }

    public void setDefault(Boolean value) {
        if (value == null) {
            unSetAttribute("default");
        }
        else {
            setAttribute("default", value.toString());
        }
    }

    public void setGroupID(String id) {
        session.testParameter(id, 1, null);

        setAttribute("id", id);
    }

    public void setSelectedFeatures(Collection<String> refs) {
        session.testParameter(refs, 1, null);
        
        removeContent(getChildren("SelectedFeature", false));
        
        Collection<Element> selectedFeatures = new ArrayList<Element>();
        
        if (refs != null && !refs.isEmpty()) {
            for (String s : refs) {
            	Element sf = session.createDeploymentElement("SelectedFeature");
            	sf.setAttribute("featureRef", s);
            	selectedFeatures.add(sf);
            }

            addContent(selectedFeatures);
        }
    }

    public Object clone() {
    	return new GroupImpl((Element)getElement().cloneNode(true), session);  
    }
}