/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.w3c.dom.Element;

public class LanguageImpl extends DisplayNameableObject implements Language {
	private static final String LANGUAGE_TYPE = "sdd-dd:LanguageType";
	
    public LanguageImpl(Element lang, SPISessionImpl session) {
        super(lang, session, LANGUAGE_TYPE);
    }

    public String getType() {
        return getAttribute("type");
    }

    public void setType(String type) {
        session.testParameter(type, 1, null);

        setAttribute("type", type);
    }

    public Object clone() {
    	return new LanguageImpl((Element)getElement().cloneNode(true), session);   
    }
}
