/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.w3c.dom.Element;

public class LanguageSetImpl extends DisplayNameableObject implements LanguageSet {
	private static final String LANGUAGE_SET_TYPE = "sdd-dd:LanguageSetType";
	
    public LanguageSetImpl(Element lang, SPISessionImpl session) {
        super(lang, session, LANGUAGE_SET_TYPE);
    }

    public Collection<Language> getLanguages() {
    	Collection<Element> languageElements = getChildren("Language");
        Collection<Language> languages = new ArrayList<Language>();

        for (Element element : languageElements) {
            languages.add(new LanguageImpl(element, session));
        }

        return languages;
    }

    public void setLanguages(Collection<Language> languages) {
        session.testParameter(languages, 1, null);
        
        if (languages != null && !languages.isEmpty()) {
            //Remove all Language elements
            removeContent(getChildren("Language", false));

            addContent(languages);
        }
        else {
            //Remove all Language elements
            removeContent(getChildren("Language", false));
        }    
    }
    
    public Object clone() {
    	return new LanguageSetImpl((Element)getElement().cloneNode(true), session);
    }
}