/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.w3c.dom.Element;

public class LocalizationUnitImpl extends InstallUnitImpl implements LocalizationUnit {
	private static final String LOCALIZATION_UNIT_TYPE = "sdd-dd:LocalizationUnitType";
	private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
	
	public LocalizationUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, LOCALIZATION_UNIT_TYPE);
    }

    public Collection<Completion> getCompletion() {
    	Collection<Completion> completions = new ArrayList<Completion>();
    	Collection<Element> completionElements = getChildren("Completion");
    	
    	for (Element completionElement : completionElements) {
    		completions.add(new CompletionImpl(completionElement, session));
    	}
    	
    	return completions;
    }

    public RequiredBase getLocalizationBase() {
        RequiredBase localizationBase = null;
        
        if (isSetElement("LocalizationBase")) {
        	localizationBase = new RequiredBaseImpl(getChild("LocalizationBase"), session);
        }
        
        return localizationBase;
    }

    public Collection<Language> getLanguages() 
    {
    	Collection<Language> languages = new ArrayList<Language>();
    	
    	if (isSetElement("Languages")) {
    		Element languagesElement = getChild("Languages");
    		Collection<Element> languageElements = session.getChildren(languagesElement, "Language");

    		for (Element element : languageElements)
            {
    			languages.add(new LanguageImpl(element, session));
    		}
    	}
    	
    	return languages;
    }

    public void setCompletion(Collection<Completion> configurationUnitCompletion) {
    	if (configurationUnitCompletion == null) {
    		unSetElement("Completion");
    	}
    	else {
    		removeContent(getChildren("Completion", false));
    		
    		addContent(configurationUnitCompletion);
    	}
    }

    public void setLocalizationBase(RequiredBase localizationBase) {
        session.testParameter(localizationBase, 1, null);
        
        if (localizationBase == null) {
        	unSetElement("RequiredBase");
        }
        else {
        	setContent((SPIDataObject)localizationBase);
        }
    }

    // Check against language pattern - http://www.w3.org/TR/xmlschema-2/#language
    public void setLanguages(Collection<Language> languages) {
    	if (languages == null) {
    		unSetElement("Languages");
    	}
    	else {
    		Element languagesElement = session.createDeploymentElement("Languages");
    		
    		for (Language language : languages) {
    		    session.insertNode(languagesElement, (SPIDataObject) language, LANGUAGES_TYPE);
    		}
    		
    		setContent(languagesElement);
    	}
    }
}
