/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Multiplicity;
import org.w3c.dom.Element;

public class MultiplicityImpl extends SPIDataObject implements Multiplicity {
	private static final String MULTIPLICITY_TYPE = "sdd-dd:MultiplicityType";
	
	public MultiplicityImpl(Element data, SPISessionImpl session) {
        super(data, session, MULTIPLICITY_TYPE);
    }

    public Collection<String> getConstrainedFeatures() {
    	Collection<String> constrainedFeatures = new ArrayList<String>();
    	Collection<Element> constrainedFeatureElements = getChildren("ConstrainedFeature");
    	
    	for (Element constrainedFeatureElement : constrainedFeatureElements) {
    		String featureRef = constrainedFeatureElement.getAttribute("featureRef");
   			constrainedFeatures.add(featureRef);
    	}
    	
    	return constrainedFeatures;
    }

    public Collection<ConstrainedResource> getConstrainedResources() {
    	Collection<ConstrainedResource> constrainedResources = new ArrayList<ConstrainedResource>();
    	Collection<Element> constrainedResourceElements = getChildren("ConstrainedResource");
    	
    	for (Element constrainedResourceElement : constrainedResourceElements) {
    		ConstrainedResource constrainedResource =
    			new ConstrainedResourceImpl(constrainedResourceElement, session);
    		constrainedResources.add(constrainedResource);
    	}
    	
    	return constrainedResources;
    }

    public BigInteger getMaxSelections() {
    	BigInteger maxSelections = null;

    	if (isSetAttribute("maxSelections")) {
    		maxSelections = new BigInteger(getAttribute("maxSelections"));
    	}
    	
    	return maxSelections;
    }

    public BigInteger getMinSelections() {
    	BigInteger minSelections = null;

    	if (isSetAttribute("minSelections")) {
    		minSelections = new BigInteger(getAttribute("minSelections"));
    	}
    	
    	return minSelections;
    }

    public Boolean getMultiplesAllowed() {
    	Boolean multiplesAllowed = null;
    	
    	if (isSetAttribute("multiplesAllowed")) {
    		multiplesAllowed = Boolean.parseBoolean(getAttribute("multiplesAllowed"));
    	}
    	
    	return multiplesAllowed;
    }

    public void setConstrainedFeatures(Collection<String> constrainedFeatureSelections) {
    	if (constrainedFeatureSelections == null) {
    		unSetElement("ConstrainedFeature");
    	}
    	else {
    		Collection<Element> constrainedFeatureElements = new ArrayList<Element>();
    		removeContent(getChildren("ConstrainedFeature", false));
    		
    		for (String constrainedFeature : constrainedFeatureSelections) {
    			Element constrainedFeatureElement = session.createDeploymentElement("ConstrainedFeature");
    			constrainedFeatureElement.setAttribute("featureRef", constrainedFeature);
    			constrainedFeatureElements.add(constrainedFeatureElement);
    		}
    		
    		addContent(constrainedFeatureElements);
    	}
    }

    public void setConstrainedResources(Collection<ConstrainedResource> constrainedResourceInstances) {
    	if (constrainedResourceInstances == null) {
    		unSetElement("ConstrainedResource");
    	}
    	else {
    		removeContent(getChildren("ConstrainedResource", false));
    		
    		addContent(constrainedResourceInstances);
    	}
    }

    public void setMaxSelections(BigInteger maxSelections) {
    	if (maxSelections == null) {
    		unSetAttribute("maxSelections");
    	}
    	else {
    		setAttribute("maxSelections", maxSelections.toString());
    	}
    }

    public void setMinSelections(BigInteger minSelections) {
    	if (minSelections == null) {
    		unSetAttribute("minSelections");
    	}
    	else {
    		setAttribute("minSelections", minSelections.toString());
    	}
    }

    public void setMultiplesAllowed(Boolean multiplesAllowed) {
        session.testParameter(multiplesAllowed, 1, null);
        
        if (multiplesAllowed == null) {
        	unSetAttribute("multiplesAllowed");
        }
        else {
        	setAttribute("multiplesAllowed", multiplesAllowed.toString());
        }
    }

    public Object clone() {
    	return new MultiplicityImpl((Element)getElement().cloneNode(true), session);
    }
}
