/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.w3c.dom.Element;

public class PackageFeatureReferenceImpl extends SPIDataObject implements PackageFeatureReference {
	private static final String PACKAGE_FEATURE_REFERENCE_TYPE = "sdd-dd:PackageFeatureReferenceType";
    
    public PackageFeatureReferenceImpl(Element data, SPISessionImpl session) {
        super(data, session, PACKAGE_FEATURE_REFERENCE_TYPE);
    }

    public String getContentElementRef() {
    	return getAttribute("contentElementRef");
    }

    public String getPackageFeatureRef() {
    	return getAttribute("packageFeatureRef");
    }

    public void setContentElementRef(String contentElementRef) {
        session.testParameter(contentElementRef, 1, null);

        setAttribute("contentElementRef", contentElementRef);
    }

    public void setPackageFeatureRef(String packageFeatureRef) {
        session.testParameter(packageFeatureRef, 1, null);

        setAttribute("packageFeatureRef", packageFeatureRef);
    }
    
    public Object clone() {
    	return new PackageFeatureReferenceImpl((Element)getElement().cloneNode(true), session);
    }
}
