/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.w3c.dom.Element;

public class ResultingChangeImpl extends DescribableObject implements ResultingChange {
	private static final String RESULTING_CHANGE_TYPE = "sdd-dd:ResultingChangeType";
	private static final String RESULTING_PROPERTY_TYPE = "sdd-dd:ResultingPropertyType";
	
	public ResultingChangeImpl(Element data, SPISessionImpl session) {
		super(data, session, RESULTING_CHANGE_TYPE);
	}

    public String getName() {
    	String name = null;
    	
    	if (isSetElement("Name")) {
    		name = getChild("Name").getTextContent();
    	}
    	
    	return name;
    }
	
	public Properties getProperties() {
    	Collection<Element> propertyElements = getChildren("Property");
    	
    	return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
	}

    public void setName(String name) {
        if (name == null) {
        	unSetElement("Name");
        }
        else {
        	Element nameElement = session.createDeploymentElement("Name");
        	nameElement.setTextContent(name);
        	
        	setContent(nameElement);
        }
    }

	public void setProperties(Properties newResultingChangeProperties) {
    	if (newResultingChangeProperties != null) {
    		Collection<Element> properties = new ArrayList<Element>();
    		removeContent(getChildren("Property", false));
    		
    		for (Enumeration<Object> e = newResultingChangeProperties.keys(); e.hasMoreElements(); ) {
    			String key = (String)e.nextElement();
    			String value = newResultingChangeProperties.getProperty(key);
    			
    			Element propertyElement = session.createDeploymentElement("Property");
    			Element propertyNameElement = session.createDeploymentElement("PropertyName");
    			Element valueElement = session.createDeploymentElement("Value");
    			
    			propertyNameElement.setTextContent(key);
    			valueElement.setTextContent(value);
                session.insertNode(propertyElement, propertyNameElement, RESULTING_PROPERTY_TYPE);
                session.insertNode(propertyElement, valueElement, RESULTING_PROPERTY_TYPE);
    			
    			properties.add(propertyElement);
    		}
    		
			addContent(properties);
    	}
    	else {
    		unSetElement("Property");
    	}
	}
	
	public Object clone() {
		return new ResultingChangeImpl((Element)getElement().cloneNode(true), session);
	}


    public Condition getCondition() {
        Condition condition = null;
        
        if (isSetElement("Condition")) {
        	condition = new ConditionImpl(getChild("Condition"), session);
        }
        
        return condition;
    }

    public Collection<Relationship> getRelationships() {
    	Collection<Relationship> relationships = new ArrayList<Relationship>();
    	Collection<Element> relationshipElements = getChildren("Relationship");
    	
    	for (Element relationshipElement : relationshipElements) {
    		relationships.add(new RelationshipImpl(relationshipElement, session));
    	}
        
        return relationships;
    }

    public void setCondition(Condition condition) {
        if (condition == null) {
            unSetElement("Condition");
        }
        else {
        	setContent((SPIDataObject)condition);
        }
   }

    public void setRelationships(Collection<Relationship> relationships) {
    	if (relationships == null) {
    		unSetElement("Relationship");
    	}
    	else {
    		removeContent(getChildren("Relationship", false));
    		
    		addContent(relationships);
    	}
    }
}
