/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.VersionConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;

public class RequiredBaseConstraintImpl extends DisplayNameableObject implements RequiredBaseConstraint {
	private static final String REQUIRED_BASE_CONSTRAINT_TYPE = "sdd-dd:RequiredBaseConstraintType";
	
	public RequiredBaseConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, REQUIRED_BASE_CONSTRAINT_TYPE);
	}

	public String getID() {
		return getAttribute("id");
	}

	public String getResourceReference() {
		return getAttribute("resourceRef");
	}

	public Boolean getTestValue() {
		Boolean testValue = null;
		
		if (isSetAttribute("testValue")) {
			testValue = Boolean.parseBoolean(getAttribute("testValue"));
		}
		
		return testValue;
	}

    public String getName() {
    	String name = null;
    	
    	if (isSetElement("Name")) {
    		name = getChild("Name").getTextContent();
    	}

    	return name;
    }

    public VersionConstraint getVersionConstraint() {
		VersionConstraint versionConstraint = null;
		
		if (isSetElement("VersionConstraint")) {
			versionConstraint = new VersionConstraintImpl(getChild("VersionConstraint"), session);
		}
		
		return versionConstraint;
	}

	public void setID(String id) {
		session.testParameter(id, 1, null);
		
		setAttribute("id", id);
	}

	public void setResourceReference(String resourceReference) {
		session.testParameter(resourceReference, 1, null);

		setAttribute("resourceRef", resourceReference);
	}

	public void setTestValue(Boolean testValue) {
		if (testValue == null) {
			unSetAttribute("testValue");
		}
		else {
			setAttribute("testValue", testValue.toString());
		}
	}
	
	public void setVersionConstraint(VersionConstraint newVersionConstraint) {
		if (newVersionConstraint == null) {
			unSetElement("VersionConstraint");
		}
		else {
			setContent((SPIDataObject)newVersionConstraint);
		}
	}

    public void setName(String name) {
    	if (name == null) {
    		unSetElement("Name");
    	}
    	else {
    		Element nameElement = session.createDeploymentElement("Name");
    		nameElement.setTextContent(name);
    		
    		setContent(nameElement);
    	}
    }

	public Object clone() {
		return new RequiredBaseConstraintImpl((Element)getElement().cloneNode(true), session);
	}
}
