/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseFactory;
import org.w3c.dom.Element;

public class RequiredBaseFactoryImpl implements RequiredBaseFactory {
	private SPISessionImpl session;
	
	public RequiredBaseFactoryImpl(SPISessionImpl session) {
		this.session = session;
	}

	public AlternativeRequiredBaseConstraint createAlternativeRequiredBaseConstraint(String id)
			throws InvalidInputException {
		if (id == null && session.isErrorCheckingEnabled()) {
			throw new InvalidInputException(1,InvalidInputException.NULL_ARGUMENT);
		}

		Element arbcElement = session.createDeploymentElement("Alternative");
		
		if (id != null) {
			arbcElement.setAttribute("id", id);
		}
		
		return new AlternativeRequiredBaseConstraintImpl(arbcElement, session);
	}

	public RequiredBase createRequiredBase() {
		return createRequiredBase("RequiredBase");
	}
	
	public RequiredBase createLocalizationBase() {
		return createRequiredBase("LocalizationBase");
	}
	
	private RequiredBase createRequiredBase(String tagName) {
		return new RequiredBaseImpl(session.createDeploymentElement(tagName), session);
	}

	public RequiredBaseConstraint createRequiredBaseConstraint(String id, String resourceReference)
			throws InvalidInputException {
		if (id == null && session.isErrorCheckingEnabled()) {
			throw new InvalidInputException(1,InvalidInputException.NULL_ARGUMENT);
		}
		else if (resourceReference == null && session.isErrorCheckingEnabled()) {
			throw new InvalidInputException(2,InvalidInputException.NULL_ARGUMENT);
		}

		Element rbcElement = session.createDeploymentElement("ResourceConstraint");
		
		if (id != null) {
			rbcElement.setAttribute("id", id);
		}
		if (resourceReference != null) {
			rbcElement.setAttribute("resourceRef", resourceReference);
		}
		
		return new RequiredBaseConstraintImpl(rbcElement, session);
	}
}
