/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityValue;
import org.w3c.dom.Element;

public class CapacityValueImpl extends SPIDataObject implements CapacityValue {
	private static final String CAPACITY_VALUE_TYPE = "sdd-dd:CapacityValueType";

	public CapacityValueImpl(Element data, SPISessionImpl session) {
		super(data, session, CAPACITY_VALUE_TYPE);
	}
	
	public String getMaximum() {
		return isSetElement("Maximum") ? getChild("Maximum").getTextContent() : null;
	}
	
	public String getMinimum() {
		return isSetElement("Minimum") ? getChild("Minimum").getTextContent() : null;
	}
	
	public String getRecommendedMaximum() {
		return isSetElement("MaximumRecommended") ? getChild("MaximumRecommended").getTextContent() : null;
	}
	
	public String getRecommendedMinimum() {
		return isSetElement("MinimumRecommended") ? getChild("MinimumRecommended").getTextContent() : null;
	}
	
	public String getUnitOfMeasure() {
		return isSetAttribute("unit") ? getAttribute("unit") : null;
	}
	
	public void setMaximum(String maximum) {
		if (maximum == null) {
			unSetElement("Maximum");
		}
		else {
			Element lowerBoundElement = session.createDeploymentElement("Maximum");
			lowerBoundElement.setTextContent(maximum);
			setContent(lowerBoundElement);
		}
	}
	
	public void setMinimum(String minimum) {
		if (minimum == null) {
			unSetElement("Minimum");
		}
		else {
			Element lowerBoundElement = session.createDeploymentElement("Minimum");
			lowerBoundElement.setTextContent(minimum);
			setContent(lowerBoundElement);
		}
	}
	
	public void setRecommendedMaximum(String recommendedMaximum) {
		if (recommendedMaximum == null) {
			unSetElement("MaximumRecommended");
		}
		else {
			Element lowerBoundElement = session.createDeploymentElement("MaximumRecommended");
			lowerBoundElement.setTextContent(recommendedMaximum);
			setContent(lowerBoundElement);
		}
	}
	
	public void setRecommendedMinimum(String recommendedMinimum) {
		if (recommendedMinimum == null) {
			unSetElement("MinimumRecommended");
		}
		else {
			Element lowerBoundElement = session.createDeploymentElement("MinimumRecommended");
			lowerBoundElement.setTextContent(recommendedMinimum);
			setContent(lowerBoundElement);
		}
	}
	
	public void setUnitOfMeasure(String unitOfMeasure) {
		if (unitOfMeasure == null) {
			unSetAttribute("unit");
		}
		else {
			setAttribute("unit", unitOfMeasure);
		}
	}
}