/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.ConsumptionConstraint;
import org.w3c.dom.Element;

public class ConsumptionConstraintImpl extends DescribableObject implements ConsumptionConstraint {
	private static final String CONSUMPTION_CONSTRAINT_TYPE = "sdd-dd:ConsumptionConstraintType";

	public ConsumptionConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, CONSUMPTION_CONSTRAINT_TYPE);
	}
 
	public String getValue() {
		return isSetElement("Value") ? getChild("Value").getTextContent() : null;
	}

	public String getPropertyName() {
		return isSetElement("PropertyName") ? getChild("PropertyName").getTextContent() : null;
	}
	
	public void setPropertyName(String propertyName) {
		session.testParameter(propertyName, 1, null);

		if (propertyName == null) {
            unSetElement("PropertyName");
        }
        else {
            Element nameElement = session.createDeploymentElement("PropertyName");
            nameElement.setTextContent(propertyName);
            setContent(nameElement);
        }
	}

	public void setValue(String ccv) {
		session.testParameter(ccv, 1, null);

		if (ccv == null) {
            unSetElement("Value");
        }
        else {
            Element valueElement = session.createDeploymentElement("Value");
            valueElement.setTextContent(ccv);
            setContent(valueElement);
        }
	}
	
	public String getUnitOfMeasure() {
		return isSetAttribute("unit") ? getAttribute("unit") : null;	
	}
 
	public void setUnitOfMeasure(String unitOfMeasure) {
		if (isSetElement("Value")) {
			if (unitOfMeasure == null || unitOfMeasure.length() == 0) {
				getChild("Value").removeAttribute("unit");
			}
			else {
				getChild("Value").setAttribute("unit", unitOfMeasure);
			}	
		}		
	}

	public String toString() {
		String consumptionConstraintContents = new String("Property name: " + getPropertyName());

		if (getUnitOfMeasure() != null) {
			consumptionConstraintContents += ", Unit of measure: " + getUnitOfMeasure();
		}

		consumptionConstraintContents += ", Value: " + getValue();
		
		return consumptionConstraintContents + "\n" + super.toString();
	}
	
	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		
		ConsumptionConstraint duplicate = new ConsumptionConstraintImpl(copy, session);
		
		return duplicate;
	}
}