/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.InternalDependency;
import org.w3c.dom.Element;

public class InternalDependencyImpl extends DescribableObject implements InternalDependency {
	private static final String INTERNAL_DEPENDENCY = "sdd-dd:InternalDependencyType";
    
    public InternalDependencyImpl(Element data, SPISessionImpl session) {
        super(data, session, INTERNAL_DEPENDENCY);
    }

    public String getContentReference() {
        return isSetAttribute("contentElementRef") ? getAttribute("contentElementRef") : null;
    }
 
    public Collection<String> getContentReferenceOperations() {
    	Collection<String> operations = new ArrayList<String>();
        
        if (isSetAttribute("contentElementRefOperation")) {
        	String op = getAttribute("contentElementRefOperation");
        	StringTokenizer st = new StringTokenizer(op);
            while (st.hasMoreTokens()) {
            	operations.add(st.nextToken());
            }
        }
        
        return operations;
    }

    public String getType() {
        return isSetAttribute("type") ? getAttribute("type") : null;
    }

    public void setContentReference(String ref) {
        session.testParameter(ref, 1, null);

        setAttribute("contentElementRef", ref);
    }

    public void setContentReferenceOperations(Collection<String> operations) {
    	// TODO check for enum value match 
        if (operations == null || operations.isEmpty()) {
        	unSetAttribute("contentElementRefOperation");
        }
        else {
        	String op = "";
        	for(String s : operations) {
        		op += s + " ";
        	}
            setAttribute("contentElementRefOperation", op.substring(0, op.length()-1));
        }
    }

    public void setType(String type) {
        if (type == null) {
            unSetAttribute("type");
        }
        else {
            setAttribute("type", type);
        }
    }
    
    public Object clone() {
    	Element copy = (Element) getElement().cloneNode(true);
		
        InternalDependencyImpl duplicate = new InternalDependencyImpl(copy, session);
        return duplicate;
    }
}
