/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;
import org.w3c.dom.Element;

public class PropertyConstraintImpl extends DescribableObject implements PropertyConstraint {
	private static final String PROPERTY_CONSTRAINT_TYPE = "sdd-dd:PropertyConstraintType";

	public PropertyConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, PROPERTY_CONSTRAINT_TYPE);
				
		if (!isSetElement("PropertyName")) { // This should be unreachable...
			Element propNameElement = session.createDeploymentElement("PropertyName");
			propNameElement.setTextContent("DEFAULT_PROPERTY_NAME");
			setContent(propNameElement);
		}
	}
	
	public String getPropertyName() {
		return isSetElement("PropertyName") ? getChild("PropertyName").getTextContent() : null;
	}
 
	public void setPropertyName(String propertyName) {
		session.testParameter(propertyName, 1, null);

		if (propertyName == null) {
			unSetElement("PropertyName");
		}
		else {
			Element propNameElement = session.createDeploymentElement("PropertyName");
			propNameElement.setTextContent(propertyName);
			setContent(propNameElement);
		}
	}
	
	public String getValue() {
		return isSetElement("Value") ? getChild("Value").getTextContent() : null;
	}
	
	public void setValue(String value) {
		session.testParameter(value, 1, null);

		if (value == null) {
			unSetElement("Value");
		}
		else {
			Element propNameElement = session.createDeploymentElement("Value");
			propNameElement.setTextContent(value);
			setContent(propNameElement);
		}
	}
	
	public PropertyValueList getValueList() {
		PropertyValueList valueList = null;
		
		if (isSetElement("ListOfValues")) {
			Element valueListElement = getChild("ListOfValues");
			valueList = new PropertyValueListImpl(valueListElement, session);
		}
		
		return valueList;
	}
	
	public void setValueList(PropertyValueList value) {
		session.testParameter(value, 1, null);

		if (value == null) {
			unSetElement("ListOfValues");
		}
		else {
			setContent(((SPIDataObject)value).getElement());
		}
	}
}