/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.w3c.dom.Element;

public class RelationshipConstraintImpl extends DescribableObject implements RelationshipConstraint {
	private static final String RELATIONSHIP_CONSTRAINT_TYPE = "sdd-dd:RelationshipConstraintType";
	private static final String PROPERTY_TYPE = "sdd-dd:PropertyType";
    
    public RelationshipConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, RELATIONSHIP_CONSTRAINT_TYPE);
    }

    public Properties getProperties() {
    	Collection<Element> propertyElements = getChildren("Property");
    	
    	return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    } 

    public String getRelatedResourceReference() {
        return getAttribute("relatedResourceRef");
    }

    public String getType() {
        return getAttribute("type");
    }

    public void setProperties(Properties props) {
    	if (props != null) {
    		Collection<Element> properties = new ArrayList<Element>();
    		removeContent(getChildren("Property", false));
    		
    		for (Enumeration<Object> e = props.keys(); e.hasMoreElements(); ) {
    			String key = (String)e.nextElement();
    			String value = props.getProperty(key);
    			
    			Element propertyElement = session.createDeploymentElement("Property");
    			Element propertyNameElement = session.createDeploymentElement("PropertyName");
    			Element valueElement = session.createDeploymentElement("Value");
    			
    			propertyNameElement.setTextContent(key);
    			valueElement.setTextContent(value);
                session.insertNode(propertyElement, propertyNameElement, PROPERTY_TYPE);
                session.insertNode(propertyElement, valueElement, PROPERTY_TYPE);
    			
    			properties.add(propertyElement);
    		}
    		
			addContent(properties);
    	}
    	else {
    		unSetElement("Property");
    	}
    }

    public void setRelatedResourceRef(String ref) {
    	if (ref == null) {
			unSetAttribute("relatedResourceRef");
    	}
		else {
			setAttribute("relatedResourceRef", ref);
		}
    }

    public void setType(String type) {
        session.testParameter(type, 1, null);

        setAttribute("type", type);
    }

    public Object clone() {
    	return new RelationshipConstraintImpl((Element)getElement().cloneNode(true), session);       
    }
}