/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.w3c.dom.Element;

public class RequirementImpl extends NameableObject implements Requirement {
	private static final String REQUIREMENT_TYPE = "sdd-dd:RequirementType";
	
	public RequirementImpl(Element data, SPISessionImpl session) {
		super(data, session, REQUIREMENT_TYPE);
	}

	public Collection<AlternativeRequirement> getAlternativeRequirements() {
		Collection<Element> arElements = getChildren("Alternative");
		Collection<AlternativeRequirement> alternatives = new ArrayList<AlternativeRequirement>();
			
		for (Element element : arElements) {
			AlternativeRequirement alternative = new AlternativeRequirementImpl(element, session);
			alternatives.add(alternative);
		}
		
		return alternatives;
	}

    public Collection<String> getOperations() {
    	Collection<String> operations = new ArrayList<String>();
        
        if (isSetAttribute("operation")) {
        	String op = getAttribute("operation");
        	StringTokenizer st = new StringTokenizer(op);
            while (st.hasMoreTokens()) {
            	operations.add(st.nextToken());
            }
        }
        
        return operations;    
    }
    
	public String getRequirementID() {
		return getAttribute("id");
	}

	public Collection<RequirementResourceConstraint> getResourceConstraints() {
		Collection<Element> rrcElements = getChildren("ResourceConstraint");
		Collection<RequirementResourceConstraint> rrcs = new ArrayList<RequirementResourceConstraint>();
		
		for (Element element : rrcElements) {
			RequirementResourceConstraint rrc = new RequirementResourceConstraintImpl(element, session);
			rrcs.add(rrc);
		}
		
		return rrcs;
	}

    public void setOperations(Collection<String> operations) {
        // TODO check for enum value match 
    	if (operations == null || operations.isEmpty()) {
        	unSetAttribute("operation");
        }
        else {
        	String op = "";
        	for(String s : operations){
        		op += s + " ";
        	}
            setAttribute("operation", op.substring(0, op.length()-1));
        }
    }

	public void setRequirementID(String requirementID) {
		session.testParameter(requirementID, 1, null);

		setAttribute("id", requirementID);
	}

	public void setResourceConstraints(Collection<RequirementResourceConstraint> newResourceConstraints) {
		if (newResourceConstraints != null && !newResourceConstraints.isEmpty()) {
            removeContent(getChildren("ResourceConstraint", false));

            addContent(newResourceConstraints);
        }
        else {
        	unSetElement("ResourceConstraint");
        }		
	}

	public void setAlternativeRequirements(Collection<AlternativeRequirement> newAlternativeRequirements) {
		if ((newAlternativeRequirements != null) && (!newAlternativeRequirements.isEmpty())) {
            removeContent(getChildren("Alternative", false));

            addContent(newAlternativeRequirements);
        }
        else {
        	unSetElement("Alternative");
        }
	}

	public Object clone() {
		return new RequirementImpl((Element)getElement().cloneNode(true), session);
	}
	
	public String toString() {
		String requirementContents = new String("Req ID: " + getRequirementID());
		
		if (isSetAttribute("operation")) {
			requirementContents += " , Operation: " + getAttribute("operation");
		}
	
		return requirementContents;
	}
}