/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.ConsumptionConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;

public class RequirementResourceConstraintImpl extends DisplayNameableObject implements RequirementResourceConstraint {
	private static final String REQUIREMENT_RESOURCE_CONSTRAINT_TYPE = "sdd-dd:RequirementResourceConstraintType";
	
	public RequirementResourceConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, REQUIREMENT_RESOURCE_CONSTRAINT_TYPE);
	}

    public String getName() {
        return isSetElement("Name") ? getChild("Name").getTextContent() : null;
    }
     
	public Collection<CapacityConstraint> getCapacityConstraintArray() {
		Collection<Element> ccElements = getChildren("CapacityConstraint");
		Collection<CapacityConstraint> capacityContraints = new ArrayList<CapacityConstraint>();
		
		for (Element element : ccElements) {
			CapacityConstraint cc = new CapacityConstraintImpl(element, session);
			capacityContraints.add(cc);
		}
			
		return capacityContraints;
	}

	public Collection<ConsumptionConstraint> getConsumptionConstraintArray() {
		Collection<Element> ccElements = getChildren("ConsumptionConstraint");
		Collection<ConsumptionConstraint> consumptionContraints = new ArrayList<ConsumptionConstraint>();
			
		for (Element element : ccElements) {
			ConsumptionConstraint cc = new ConsumptionConstraintImpl(element, session);
			consumptionContraints.add(cc);
		}
			
		return consumptionContraints;
	}

    public Collection<PropertyConstraint> getPropertyConstraintArray() {
    	Collection<Element> rcElements = getChildren("PropertyConstraint");
		Collection<PropertyConstraint> propertyContraints = new ArrayList<PropertyConstraint>();
			
		for (Element element : rcElements) {
			PropertyConstraint cc = new PropertyConstraintImpl(element, session);
			propertyContraints.add(cc);
		}
			
		return propertyContraints;
    }
    
	public String getResourceConstraintID() {
		return getAttribute("id");
	}

	public String getResourceReference() {
		return getAttribute("resourceRef");
	}

	public Boolean getTestValue() {
		return new Boolean(getAttribute("testValue")); 
	}

	public Collection<VersionConstraint> getVersionConstraintArray() {
		Collection<Element> vcElements = getChildren("VersionConstraint");
		Collection<VersionConstraint> versionContraints = new ArrayList<VersionConstraint>();
			
		for (Element element : vcElements) {
			VersionConstraint vc = new VersionConstraintImpl(element, session);
			versionContraints.add(vc);
		}
			
		return versionContraints;
	}
	
	public Collection<UniquenessConstraint> getUniquenessConstraintArray() {
		Collection<Element> ucElements = getChildren("UniquenessConstraint");
		Collection<UniquenessConstraint> uniquenessContraints = new ArrayList<UniquenessConstraint>();
			
		for (Element element : ucElements) {
			UniquenessConstraint uc = new UniquenessConstraintImpl(element, session);
			uniquenessContraints.add(uc);
		}
			
		return uniquenessContraints;
	}
	
	public Collection<RelationshipConstraint> getRelationshipConstraintArray() {
		Collection<Element> rcElements = getChildren("RelationshipConstraint");
		Collection<RelationshipConstraint> relationshipContraints = new ArrayList<RelationshipConstraint>();
			
		for (Element element : rcElements) {
			RelationshipConstraint rc = new RelationshipConstraintImpl(element, session);
			relationshipContraints.add(rc);
		}
			
		return relationshipContraints;
	}

    public void setName(String name) {
    	if (name == null) {
            unSetElement("Name");
        }
        else {
            Element nameElement = session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            setContent(nameElement);
        }
    }

	public void setCapacityConstraintArray(Collection<CapacityConstraint> newCapacityConstraintArray) {
		if ((newCapacityConstraintArray != null) && (!newCapacityConstraintArray.isEmpty())) {
            removeContent(getChildren("CapacityConstraint", false));

            addContent(newCapacityConstraintArray);
        }
        else {
        	unSetElement("CapacityConstraint");
        }
	}

	public void setConsumptionConstraintArray(Collection<ConsumptionConstraint> newConsumptionConstraintArray) {
		if ((newConsumptionConstraintArray != null) && (!newConsumptionConstraintArray.isEmpty())) {
            removeContent(getChildren("ConsumptionConstraint", false));

            addContent(newConsumptionConstraintArray);
        }
        else {
        	unSetElement("ConsumptionConstraint");
        }
	}

    public void setPropertyConstraintArray(Collection<PropertyConstraint> propertyConstraints) {
    	if ((propertyConstraints != null) && (!propertyConstraints.isEmpty())) {
            removeContent(getChildren("PropertyConstraint", false));

            addContent(propertyConstraints);
        }
        else {
        	unSetElement("PropertyConstraint");
        }
    }
    
	public void setResourceConstraintID(String resourceConstraintID) {
		session.testParameter(resourceConstraintID, 1, null);

		setAttribute("id", resourceConstraintID);
	}

	public void setResourceReference(String resourceReference) {
		session.testParameter(resourceReference, 1, null);

		setAttribute("resourceRef", resourceReference);
	}

	public void setTestValue(Boolean testValue) {
		if (testValue == null) {
			unSetAttribute("testValue");
		}
		else {
			setAttribute("testValue", testValue.toString());
		}
	}

	public void setVersionConstraintArray(Collection<VersionConstraint> newVersionConstraintArray) {
		if ((newVersionConstraintArray != null) && (!newVersionConstraintArray.isEmpty())) {
            removeContent(getChildren("VersionConstraint", false));

            addContent(newVersionConstraintArray);
        }
        else {
        	unSetElement("VersionConstraint");
        }
	}
	
	public void setUniquenessConstraintArray(Collection<UniquenessConstraint> newUniquenessConstraintArray) {
		if ((newUniquenessConstraintArray != null) && (!newUniquenessConstraintArray.isEmpty())) {
            removeContent(getChildren("UniquenessConstraint", false));

            addContent(newUniquenessConstraintArray);
        }
        else {
        	unSetElement("UniquenessConstraint");
        }
	}

	public void setRelationshipConstraintArray(Collection<RelationshipConstraint> newRelationshipConstraintArray) {
		if ((newRelationshipConstraintArray != null) && (!newRelationshipConstraintArray.isEmpty())) {
            removeContent(getChildren("RelationshipConstraint", false));

            addContent(newRelationshipConstraintArray);
        }
        else {
        	unSetElement("RelationshipConstraint");
        }
	}
	
	public Object clone() {
		return new RequirementResourceConstraintImpl((Element)getElement().cloneNode(true), session);
	}
	
	public String toString() {
		String contents = new String(
				"ResourceConstraint ID: " + this.getResourceConstraintID() +
				" , Resource Reference: " + this.getResourceReference() +
				"\n" + super.toString());
		
		return contents;
	}
}