/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionRangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;

public class VersionConstraintImpl extends DescribableObject implements VersionConstraint {
	private static final String VERSION_CONSTRAINT_TYPE = "sdd-dd:VersionConstraintType";
	private static final String VERSION_CONSTRAINT_VALUE_TYPE = "sdd-dd:VersionConstraintValueType";
		
	public VersionConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, VERSION_CONSTRAINT_TYPE);	
	}
 
	public Collection<VersionValue> getCertifiedVersionValues() {
		Collection<VersionValue> versionValues = new ArrayList<VersionValue>();

        if (isSetElement("Certified")) {
            Collection<Element> versionValueElementList = session.getChildren(getChild("Certified"), "Value");

            for (Element element : versionValueElementList) {
                versionValues.add(new VersionValueImpl(element, session));
            }
        }

        return versionValues;		
	}
	
	public Collection<VersionValue> getVersionValues() {
		Collection<VersionValue> versionValues = new ArrayList<VersionValue>();

        if (isSetElement("Supported")) {
            Collection<Element> versionValueElementList = session.getChildren(getChild("Supported"), "Value");

            for (Element element : versionValueElementList) {
                versionValues.add(new VersionValueImpl(element, session));
            }
        }

        return versionValues;
	}

	public Collection<VersionRange> getCertifiedVersionRanges() {		
		Collection<VersionRange> versionRanges = new ArrayList<VersionRange>();

        if (isSetElement("Certified")) {
            Collection<Element> versionRangeElementList = session.getChildren(getChild("Certified"), "Range");

            for (Element element : versionRangeElementList) {
                versionRanges.add(new VersionRangeImpl(element, session));
            }
        }

        return versionRanges;
	}

	public Collection<VersionRange> getVersionRanges() {
        Collection<VersionRange> versionRanges = new ArrayList<VersionRange>();

        if (isSetElement("Supported")) {
            Collection<Element> versionRangeElementList = session.getChildren(getChild("Supported"), "Range");

            for (Element element : versionRangeElementList) {
                versionRanges.add(new VersionRangeImpl(element, session));
            }
        }

        return versionRanges;
	}
	
	public void setCertifiedVersionValues(Collection<VersionValue> newCertifiedVersionValues) {
		Element certified;

        if (isSetElement("Certified")) {
            certified = getChild("Certified");
        }
        else {
            certified = session.createDeploymentElement("Certified");
        }
        
        //Remove all Value elements
        Collection<Element> containedPackageNodeList = session.getChildren(certified, "Value");
        for (Element element : containedPackageNodeList) {
            certified.removeChild(element);
        }

        if (newCertifiedVersionValues != null && !newCertifiedVersionValues.isEmpty()) {
            for (VersionValue versionValue : newCertifiedVersionValues) {
                session.insertNode(certified, (SPIDataObject) versionValue, VERSION_CONSTRAINT_VALUE_TYPE);
            }

            setContent(certified);
        }
        else {
            if (session.getChildren(certified, "Range").isEmpty()) {
                unSetElement("Certified");
            }
        }
	}

	public void setVersionValues(Collection<VersionValue> newVersionValues) {
		Element supported;

		if (isSetElement("Supported")) {
			supported = getChild("Supported");
		}
		else {
			supported = session.createDeploymentElement("Supported");
		}

        //Remove all Value elements
        Collection<Element> containedPackageNodeList = session.getChildren(supported, "Value");
        for (Element element : containedPackageNodeList) {
            supported.removeChild(element);
        }

		if (newVersionValues != null && !newVersionValues.isEmpty()) {
			for (VersionValue versionValue : newVersionValues) {
			    session.insertNode(supported, (SPIDataObject) versionValue, VERSION_CONSTRAINT_VALUE_TYPE);
			}

			setContent(supported);
		}
		else {
			if (session.getChildren(supported, "Range").isEmpty()) {
				unSetElement("Supported");
			}
		}
	}
	
	public void setCertifiedVersionRanges(Collection<VersionRange> newCertifiedVersionRanges) {
		Element certified;

        if (isSetElement("Certified")) {
            certified = getChild("Certified");
        }
        else {
            certified = session.createDeploymentElement("Certified");
        }

        //Remove all Range elements
        Collection<Element> containedPackageNodeList = session.getChildren(certified, "Range");
        for (Element element : containedPackageNodeList) {
            certified.removeChild(element);
        }

        if (newCertifiedVersionRanges != null && !newCertifiedVersionRanges.isEmpty()) {
            for (VersionRange versionRange : newCertifiedVersionRanges) {
                session.insertNode(certified, (SPIDataObject) versionRange, VERSION_CONSTRAINT_VALUE_TYPE);
            }

            setContent(certified);
        }
        else {
            if (session.getChildren(certified, "Value").isEmpty()) {
                unSetElement("Certified");
            }
        }
	}

	public void setVersionRanges(Collection<VersionRange> newVersionRanges) {
		Element supported;

        if (isSetElement("Supported")) {
            supported = getChild("Supported");
        }
        else {
            supported = session.createDeploymentElement("Supported");
        }
        
        //Remove all Range elements
        Collection<Element> containedPackageNodeList = session.getChildren(supported, "Range");
        for (Element element : containedPackageNodeList) {
            supported.removeChild(element);
        }

        if (newVersionRanges != null && !newVersionRanges.isEmpty()) {
            for (VersionRange versionRange : newVersionRanges) {
                session.insertNode(supported, (SPIDataObject) versionRange, VERSION_CONSTRAINT_VALUE_TYPE);
            }

            setContent(supported);
        }
        else {
            if (session.getChildren(supported, "Value").isEmpty()) {
                unSetElement("Supported");
            }
        }
	}

	public Object clone() {
		return new VersionConstraintImpl((Element)getElement().cloneNode(true), session);
		
	}
	
	public String toString() {
		String contents = new String("Version Constraint\n" + super.toString());
		
		return contents;
	}
}
