/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.w3c.dom.Element;

public class ConditionalDerivedVariableImpl extends BaseVariableImpl implements ConditionalDerivedVariable {
	private static final String DERIVED_VARIABLE_TYPE = "sdd-dd:DerivedVariableType";

	public ConditionalDerivedVariableImpl(Element data, SPISessionImpl session) {
		super(data, session, DERIVED_VARIABLE_TYPE);
	}

	public Collection<ConditionalDerivedVariableExpression> getConditionalDerivedExpressions() {
		Collection<Element> cdveElements = getChildren("ConditionalExpression");
		Collection<ConditionalDerivedVariableExpression> cdveList = new ArrayList<ConditionalDerivedVariableExpression>();
		
		for (Element element : cdveElements) {
			ConditionalDerivedVariableExpression temp = new ConditionalDerivedVariableExpressionImpl(element, session);
			cdveList.add(temp);
		}
		
		return cdveList;
	}

	public void setConditionalDerivedExpressions(Collection<ConditionalDerivedVariableExpression> newExpressions) {
		session.testParameter(newExpressions, 1, null);

		removeContent(getChildren("ConditionalExpression", false));
		
		addContent(newExpressions);
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		ConditionalDerivedVariableImpl duplicate = new ConditionalDerivedVariableImpl(copy, session);
		
		return duplicate;
	}	
}