/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.w3c.dom.Element;

public class DerivedVariableImpl extends BaseVariableImpl implements DerivedVariable {
	private static final String DERIVED_VARIABLE_TYPE = "sdd-dd:DerivedVariableType";
	
	public DerivedVariableImpl(Element data, SPISessionImpl session) {
		super(data, session, DERIVED_VARIABLE_TYPE);
	}
	
	public String getExpression() {
		return getChild("Expression").getTextContent();
	}

	public void setExpression(String expression) {
		session.testParameter(expression, 1, null);
		
		Element expressionElement = session.createDeploymentElement("Expression");
        expressionElement.setTextContent(expression);
		setContent(expressionElement);
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		DerivedVariableImpl duplicate = new DerivedVariableImpl(copy, session);
        
		return duplicate;
	}	
}
