/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.w3c.dom.Element;

public class OutputVariableImpl extends BaseVariableImpl implements OutputVariable {
	private static final String OUTPUT_VARIABLE_TYPE = "sdd-dd:OutputVariableType";
    
    public OutputVariableImpl(Element data, SPISessionImpl session) {
        super(data, session, OUTPUT_VARIABLE_TYPE);
    }

    public String getOutputParameterName() {
    	return isSetAttribute("outputParameterName") ? getAttribute("outputParameterName") :  null;
    }

    public void setOutputParameterName(String outputParameterName) {
    	if (outputParameterName == null) {
			unSetAttribute("outputParameterName");
    	}
		else {
			setAttribute("outputParameterName", outputParameterName);
		}
    }

    public Object clone() {
    	Element copy = (Element) getElement().cloneNode(true);
    	OutputVariableImpl duplicate = new OutputVariableImpl(copy, session);
		
        return duplicate;
    }
}