/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterBoundary;
import org.w3c.dom.Element;

public class ParameterBoundaryImpl extends SPIDataObject implements ParameterBoundary {
	private static final String BOUNDARY_TYPE = "sdd-dd:BoundaryType";

    public ParameterBoundaryImpl(Element data, SPISessionImpl session) {
        super(data, session, BOUNDARY_TYPE);
    }

    public Integer getLowerBound() {
    	Integer lowerBound = null;
    	
    	if (isSetElement("LowerBound")) {
    		try {
    			lowerBound = Integer.decode(getChild("LowerBound").getTextContent());
    		}
    		catch (NumberFormatException e) {	
    		}
    	}
    	
    	return lowerBound;
    }

    public Integer getUpperBound() {
    	Integer upperBound = null;
    	
    	if (isSetElement("UpperBound")) {
    		try {
    			upperBound = Integer.decode(getChild("UpperBound").getTextContent());
    		}
    		catch (NumberFormatException e) {	
    		}
    	}
    	
    	return upperBound;
    }

    public void setLowerBound(Integer lowerBound) {
    	if (lowerBound == null) {
			unSetElement("LowerBound");
		}
		else {
			Element lowerBoundElement = session.createDeploymentElement("LowerBound");
			lowerBoundElement.setTextContent(lowerBound.toString());
			setContent(lowerBoundElement);
		}
    }

    public void setUpperBound(Integer upperBound) {
    	if (upperBound == null) {
			unSetElement("UpperBound");
		}
		else {
			Element upperBoundElement = session.createDeploymentElement("UpperBound");
			upperBoundElement.setTextContent(upperBound.toString());
			setContent(upperBoundElement);
		}
    }

    public Object clone() {
        Element copy = (Element) getElement().cloneNode(true);
        ParameterBoundaryImpl duplicate = new ParameterBoundaryImpl(copy, session);

        return duplicate;
    }
}
