/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.URIParameter;
import org.w3c.dom.Element;

public class ParameterGroupImpl extends SPIDataObject implements ParameterGroup {
	private static final String PARAMETERS_TYPE = "sdd-dd:ParametersType";
	
	public ParameterGroupImpl(Element data, SPISessionImpl session) {
		super(data, session, PARAMETERS_TYPE);
	}
	
	public Collection<BooleanParameter> getBooleanParameters() {
		Collection<Element> parameterElements = getChildren("BooleanParameter");
		Collection<BooleanParameter> pList = new ArrayList<BooleanParameter>();
		
		for (Element element : parameterElements) {
			BooleanParameter temp = new BooleanParameterImpl(element, session);
			pList.add(temp);
		}

		return pList;
	}

	public Collection<IntegerParameter> getIntegerParameters() {
		Collection<Element> parameterElements = getChildren("IntegerParameter");
		Collection<IntegerParameter> pList = new ArrayList<IntegerParameter>();
		
		for (Element element : parameterElements) {
			IntegerParameter temp = new IntegerParameterImpl(element, session);
			pList.add(temp);
		}

		return pList;
	}

	public Collection<StringParameter> getStringParameters() {
		Collection<Element> parameterElements = getChildren("StringParameter");
		Collection<StringParameter> pList = new ArrayList<StringParameter>();
		
		for (Element element : parameterElements) {
			StringParameter temp = new StringParameterImpl(element, session);
			pList.add(temp);
		}

		return pList;
	}

	public Collection<URIParameter> getURIParameters() {
		Collection<Element> parameterElements = getChildren("URIParameter");
		Collection<URIParameter> pList = new ArrayList<URIParameter>();
		
		for (Element element : parameterElements) {
			URIParameter temp = new URIParameterImpl(element, session);
			pList.add(temp);
		}

		return pList;
	}

	public void setBooleanParameters(Collection<BooleanParameter> booleanParameters) {
		if (booleanParameters != null) {
            removeContent(getChildren("BooleanParameter", false));

            addContent(booleanParameters);
        }
        else {
        	unSetElement("BooleanParameter");
        }				
	}
	
	public void setIntegerParameters(Collection<IntegerParameter> integerParameters) {
		if (integerParameters != null) {
            removeContent(getChildren("IntegerParameter", false));

            addContent(integerParameters);
        }
        else {
        	unSetElement("IntegerParameter");
        }
	}

	public void setStringParameters(Collection<StringParameter> stringParameters) {
		if (stringParameters != null) {
            removeContent(getChildren("StringParameter", false));

            addContent(stringParameters);
        }
        else {
        	unSetElement("StringParameter");
        }				
	}

	public void setURIParameters(Collection<URIParameter> uriParameters) {
		if (uriParameters != null) {
            removeContent(getChildren("URIParameter", false));

            addContent(uriParameters);
        }
        else {
        	unSetElement("URIParameter");
        }
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		ParameterGroupImpl duplicate = new ParameterGroupImpl(copy, session);

		return duplicate;
	}
}
