/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.Parameter;
import org.w3c.dom.Element;

public abstract class ParameterImpl extends NameableObject implements Parameter {
	private static final String BASE_PARAMETER_TYPE = "sdd-dd:BaseParameterType";
       
    public ParameterImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }
    
    public ParameterImpl(Element data, SPISessionImpl session) {
        super(data, session, BASE_PARAMETER_TYPE);
    }

    public String getDefaultValue() {
    	return isSetAttribute("defaultValue") ? getAttribute("defaultValue") :  null;  
    }

    public Collection<String> getOperations() {
        Collection<String> operations = new ArrayList<String>();
        
        if (isSetAttribute("operation")) {
        	String op = getAttribute("operation");
        	StringTokenizer st = new StringTokenizer(op);
            while (st.hasMoreTokens()) {
            	operations.add(st.nextToken());
            }
        }
        
        return operations;
    }

    public String getParameterID() {
        return getAttribute("id");
    }

    public Boolean isRequired() {
    	return isSetAttribute("required") ? new Boolean(getAttribute("required")) :  null;
    }

    public Boolean isSensitive() {
    	return isSetAttribute("sensitive") ? new Boolean(getAttribute("sensitive")) :  null;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
        	unSetAttribute("defaultValue");
        }
        else {
            setAttribute("defaultValue", defaultValue);
        }
    }

    public void setOperations(Collection<String> operations) {
        // TODO check for enum value match 
        if (operations == null || operations.isEmpty()) {
        	unSetAttribute("operation");
        }
        else {
        	String op = "";
        	for(String s : operations){
        		op += s + " ";
        	}
            setAttribute("operation", op.substring(0, op.length()-1));
        }
    }

    public void setParameterID(String parameterID) {
        session.testParameter(parameterID, 1, null);

        setAttribute("id", parameterID);
    }

    public void setRequired(Boolean required) {
        if (required == null) {
        	unSetAttribute("required");
        }
        else {
            setAttribute("required", required.toString());
        }
    }

    public void setSensitive(Boolean sensitive) {
        if (sensitive == null) {
        	unSetAttribute("sensitive");
        }
        else {
            setAttribute("sensitive", sensitive.toString());
        }
    }
}