/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ParameterImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.w3c.dom.Element;

public class StringParameterImpl extends ParameterImpl implements StringParameter {
	private static final String STRING_PARAMETER_TYPE = "sdd-dd:StringParameterType";

	public StringParameterImpl(Element data, SPISessionImpl session) {
		super(data, session, STRING_PARAMETER_TYPE);
	}

	public BigInteger getMaxLength() {
		return isSetAttribute("maxLength") ? new BigInteger(getAttribute("maxLength")) :  null;
	}

	public BigInteger getMinLength() {
		return isSetAttribute("minLength") ? new BigInteger(getAttribute("minLength")) :  null;
	}

	public Collection<String> getValidValues() {
		Collection<String> values = new ArrayList<String>();
		Collection<Element> valueElements = getChildren("ValidValue");

		for (Element element : valueElements) {
			values.add(element.getTextContent());
		}

		return values;
	}

	public String getCase() {
		return getAttribute("case");
	}

	public void setMaxLength(BigInteger maxLength) {
		if (maxLength == null) {
			unSetAttribute("maxLength");
		}
		else {
			setAttribute("maxLength", maxLength.toString());
		}
	}

	public void setMinLength(BigInteger minLength) {
		if (minLength == null) {
			unSetAttribute("minLength");
		}
		else {
			setAttribute("minLength", minLength.toString());
		}
	}

	public void setValidValues(Collection<String> validValues) {
		Collection<Element> values = new ArrayList<Element>();
		removeContent(getChildren("ValidValue", false));

		for(String s : validValues) {
			if (s != null && s.length() != 0) {
				Element validvalue = session.createDeploymentElement("ValidValue");
				validvalue.setTextContent(s);
				values.add(validvalue);
			}
		}

		addContent(values);
	}

	public void setCase(String caseValue) {
		setAttribute("case", caseValue);
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		StringParameterImpl duplicate = new StringParameterImpl(copy, session);

		return duplicate;
	}
}