/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterBoundary;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.URIParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.VariableFactory;
import org.w3c.dom.Element;

public class VariableFactoryImpl implements VariableFactory {
	private SPISessionImpl session;
	private static final String DERIVED_VARIABLE_TYPE = "sdd-dd:DerivedVariableType";
    
    public VariableFactoryImpl (SPISessionImpl session) {
        this.session = session;
    }

    public BooleanParameter createBooleanParameter(String parameterID) {
        session.testParameter(parameterID, 1, null);

        Element booleanParamElement = session.createDeploymentElement("BooleanParameter");
		booleanParamElement.setAttribute("id", parameterID);
		
		return new BooleanParameterImpl(booleanParamElement, session);
    }

    public ConditionalDerivedVariable createConditionalDerivedVariable(String variableID,
            Collection<ConditionalDerivedVariableExpression> cdvExpressions) {
        session.testParameter(variableID, 1, null);
        session.testParameter(cdvExpressions, 2, null);
        
        for (ConditionalDerivedVariableExpression cdve : cdvExpressions) {
            if (cdve == null) {
                throw new InvalidInputException(2,InvalidInputException.NULL_ARRAY_ELEMENT);
            }
        }
        
        Element dvElement = session.createDeploymentElement("DerivedVariable");
                
        dvElement.setAttribute("id", variableID);
        
        for (ConditionalDerivedVariableExpression cdve : cdvExpressions) {
            session.insertNode(dvElement, (SPIDataObject) cdve, DERIVED_VARIABLE_TYPE);
        }
                
        ConditionalDerivedVariable cdv = new ConditionalDerivedVariableImpl(dvElement, session);
        
        return cdv;
    }

    public ConditionalDerivedVariableExpression createConditionalDerivedVariableExpression(String expression,
    		Condition condition) {
        session.testParameter(expression, 1, null);
        session.testParameter(condition, 2, null);
        
        Element cdveElement = session.createDeploymentElement("ConditionalExpression");
        
        ConditionalDerivedVariableExpression cdve = new ConditionalDerivedVariableExpressionImpl(cdveElement, session);
        
        cdve.setExpression(expression);
        cdve.setCondition(condition);
        
        return cdve;
    }

    public DerivedVariable createDerivedVariable(String variableID, String expression) {
    	return createDerivedVariable(variableID, expression, "DerivedVariable");
    }
    
    public DerivedVariable createVariable(String variableID, String expression) {
    	return createDerivedVariable(variableID, expression, "Variable");
    }

    private DerivedVariable createDerivedVariable(String variableID, String expression, String elementName) {
        session.testParameter(variableID, 1, null);
        session.testParameter(expression, 2, null);
        
        Element dvElement = session.createDeploymentElement(elementName);
        
        Element expElement = session.createDeploymentElement("Expression");
        expElement.setTextContent(expression);
        
        dvElement.setAttribute("id", variableID);
        session.insertNode(dvElement, expElement, DERIVED_VARIABLE_TYPE);
        
        return new DerivedVariableImpl(dvElement, session);
    }
    
    public IntegerParameter createIntegerParameter(String parameterID) {
        session.testParameter(parameterID, 1, null);

        Element integerParamElement = session.createDeploymentElement("IntegerParameter");
        integerParamElement.setAttribute("id", parameterID);
		
		return new IntegerParameterImpl(integerParamElement, session);
    }

    public ParameterGroup createParameterGroup() {
        return new ParameterGroupImpl(session.createDeploymentElement("Parameters"), session);
    }

    public ResourceProperty createResourceProperty(String variableID, String resourceReference) {
        session.testParameter(variableID, 1, null);
        session.testParameter(resourceReference, 2, null);

        Element rptElement = session.createDeploymentElement("ResourceProperty");
        
        rptElement.setAttribute("resourceRef", resourceReference);
        rptElement.setAttribute("id", variableID);
        
        return new ResourcePropertyImpl(rptElement, session);
    }

    public StringParameter createStringParameter(String parameterID) {
        session.testParameter(parameterID, 1, null);
        
        Element stringParamElement = session.createDeploymentElement("StringParameter");
        stringParamElement.setAttribute("id", parameterID);
		
		return new StringParameterImpl(stringParamElement, session);
    }

    public URIParameter createURIParameter(String parameterID) {
        session.testParameter(parameterID, 1, null);
        
        Element uriParamElement = session.createDeploymentElement("URIParameter");
        uriParamElement.setAttribute("id", parameterID);
		
		return new URIParameterImpl(uriParamElement, session);
    }

    public ParameterBoundary createParameterBoundary() {
        Element boundaryElement = session.createDeploymentElement("Bounds");

        return new ParameterBoundaryImpl(boundaryElement, session);
    }

    public OutputVariable createOutputVariable(String id) throws InvalidInputException {
        session.testParameter(id, 1, null);
        
        Element ovElement = session.createDeploymentElement("OutputVariable");
        ovElement.setAttribute("id", id);
		
		return new OutputVariableImpl(ovElement, session);
    }
}