/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.DigestMethod;
import org.w3c.dom.Element;

public class DigestMethodImpl extends SPIDataObject implements DigestMethod {
	private static final String DIGEST_METHOD_TYPE = "ds:DigestMethod";
	
	public DigestMethodImpl(Element data, SPISessionImpl session) {
		super(data, session, DIGEST_METHOD_TYPE);
	}

	public String getAlgorithm() {
		return getAttribute("Algorithm");
	}

	public void setAlgorithm(String newAlgorithm) {
		session.testParameter(newAlgorithm, 1, null);
		
		setAttribute("Algorithm", newAlgorithm);
	}
}
