/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.KeyInfo;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.Signature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.SignatureObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.SignedInfo;
import org.w3c.dom.Element;

public class SignatureImpl extends SPIDataObject implements Signature  {
	private static final String SIGNATURE_TYPE = "ds:SignatureType";

	public SignatureImpl(Element data, SPISessionImpl session) {
		super(data, session, SIGNATURE_TYPE);
	}

	public String getId() {
		return getAttribute("Id");
	}

	public KeyInfo getKeyInfo() {
		// TODO Auto-generated method stub
		return null;
	}

	public SignatureObject getObject() {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getSignatureValue() {
		byte[] signatureValue = null;
		
		if (isSetElement("SignatureValue")) {
			String signatureValueString = getChild("SignatureValue").getTextContent();
			signatureValue = signatureValueString.getBytes();
		}

		return signatureValue;
	}

	public String getSignatureValueId() {
		String signatureValueId = null;
		
		if (isSetElement("SignatureValue")) {
			Element signatureValue = getChild("SignatureValue");
			
			if (signatureValue.getAttribute("Id") != null) {
				signatureValueId = signatureValue.getAttribute("Id");
			}
		}
		
		return signatureValueId;
	}

	public SignedInfo getSignedInfo() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setId(String id) {
		setAttribute("Id", id);
	}

	public void setKeyInfo(KeyInfo keyInfo) {
		// TODO Auto-generated method stub
	}

	public void setObject(SignatureObject object) {
		// TODO Auto-generated method stub		
	}

	public void setSignatureValue(byte[] signatureValue) {
		if (!isSetElement("SignatureValue")) {
			Element signatureValueElement = session.createXmlDsigElement("SignatureValue");
			setContent(signatureValueElement);
		}
			
		Element signatureValueElement = getChild("SignatureValue");
		signatureValueElement.setTextContent(new String(signatureValue));
		setContent(signatureValueElement);
	}

	public void setSignatureValueId(String id) {
		if (!isSetElement("SignatureValue")) {
			Element signatureValueElement = session.createXmlDsigElement("SignatureValue");
			setContent(signatureValueElement);
		}
			
		Element signatureValueElement = getChild("SignatureValue");
		signatureValueElement.setAttribute("Id", id);
		setContent(signatureValueElement);
	}

	public void setSignedInfo(SignedInfo signedInfo) {
		// TODO Auto-generated method stub		
	}	
}