/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.examples.common.spi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactArgument;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactOutputVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.BaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.ConsumptionConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterBoundary;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.URIParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.VariableFactory;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;


/**
 * This example demonstrates the creation of a Deployment Descriptor.
 * Note that this example is unconcerned with referential integrity, or any
 * other notions of good descriptor design.  Rather, it is solely meant to
 * demonstrate the mechanics use of SPI to create the various parts of a
 * descriptor, and write it out to a stream. 
 *
 */
public class DescriptorCreationExample
{

    public static void main(String[] args) 
    {

        
        // Create an SPI session, along with any necessary factories
        SPISession spi = SPISession.DEFAULT_INSTANCE;
        BaseFactory baseFactory = spi.createBaseFactory();
        ContentUnitFactory cuFactory = spi.createContentUnitFactory();
        ArtifactFactory artifactFactory = spi.createArtifactFactory();
        VariableFactory variableFactory = spi.createVariableFactory();
        RequirementFactory requirementFactory = spi.createRequirementFactory();
        RequiredBaseFactory rbFactory = spi.createRequiredBaseFactory();
        ConditionFactory conditionFactory = spi.createConditionFactory();

        // Set up logging.  One could simply direct the output of the SPI
        // logger to a file, or whatever destination was desired.  However,
        // it's likely that an application using SPI will have one or more
        // loggers of its own.  So, this example demonstrates the connection
        // of the SPI logger to a separate application logger.
        //
        // Note that the ConsoleHandler used below sends output to stderr.
        // When output is going to both stdout and stderr, they may not appear
        // on the console in the expected order.
        //
//        Logger l = Logger.getLogger("Descriptor.Creation.Example.Logger");
//        l.setLevel(Level.FINEST);
//        l.setUseParentHandlers(false);
//        
//        Handler ch = new ConsoleHandler();
//        ch.setLevel(Level.FINEST);
//        l.addHandler(ch);
//        ForwardingHandler fh = new ForwardingHandler(l);
//        fh.setLevel(Level.FINEST);
//
//        Logger spiLogger = spi.getLogger(); 
//        spiLogger.setLevel(Level.FINEST);
//        spiLogger.addHandler(fh);
//        
//        l.info("Starting DescriptorCreationExample...");
        
        // Create a resource.  Resource creation is performed before Descriptor
        // creation because resources must be specified at the time of
        // Descriptor creation.  Note that one can update the resources defined
        // for a Descriptor post-creation, which means one could simply create an
        // array containing one empty resource, use that during Descriptor creation,
        // then update the Descriptor with an array of fully defined resources at
        // a later time.
        Collection<Resource> resources = new ArrayList<Resource>();
        Resource resource = baseFactory.createResource("MyOS","OperatingSystem");
        resource.setName("My Wonderful OS");
        
        // Remember that an object cannot have a short description without having a
        // regular description.  If a short description is specified, and a regular
        // description has not been specified, then the short description will be used
        // as the regular description as well.
        resource.setDescription(new TranslatableString("The coolest OS ever","cool_xKey"));
        resource.setShortDescription(new TranslatableString("The coolest OS ever","cool_xKey"));
        resources.add(resource);

        
        // Create an artifact to be used as an install artifact.
        Artifact install = artifactFactory.createInstallArtifact();
        install.setContentReference("artifact_content_ref");
        install.setResourceReference("artifact_Resource_Ref");
        install.setWeight(BigInteger.ONE);
        
        Collection<AdditionalContent> additionalContents = new ArrayList<AdditionalContent>();
        additionalContents.add(artifactFactory.createAdditionalContent("af1"));
        AdditionalContent additionalContent = artifactFactory.createAdditionalContent("af2");
        additionalContent.setType("af_type");
        
        Collection<StringSubstitution> stringSubs = new ArrayList<StringSubstitution>();
        stringSubs.add(artifactFactory.createStringSubstitution("*.exe", "SOME_EXE"));
        StringSubstitution stringSub = artifactFactory.createStringSubstitution("A?+", "AdventureTime");
        stringSub.setRequired(Boolean.TRUE);
        stringSubs.add(stringSub);
        additionalContent.setStringSubstitutions(stringSubs);

        additionalContents.add(additionalContent);
        install.setAdditionalContents(additionalContents);
        
        Collection<ArtifactOutputVariable> outputParms = new ArrayList<ArtifactOutputVariable>();
        outputParms.add(new ArtifactOutputVariable("varRef_1", "output_name1"));
        outputParms.add(new ArtifactOutputVariable("varRef_2", "output_name2"));
        outputParms.add(new ArtifactOutputVariable("varRef_3", null));
        install.setOutputVariables(outputParms);
        
        Collection<ArtifactArgument> inputArgs = new ArrayList<ArtifactArgument>();
        inputArgs.add(new ArtifactArgument("InputParmName_1", "InputParmValue", Boolean.TRUE));
        inputArgs.add(new ArtifactArgument("InputParmName_2", null, Boolean.FALSE));
        install.setArguments(inputArgs);


        // Create an Installable Unit as the content unit to be included in
        // the new descriptor.
        InstallableUnit iu = 
            cuFactory.createInstallableUnit("IU_ID", "IU_TARGET_REF",
                    install, ContentUnitFactory.INSTALL_ARTIFACT);
        iu.setTargetResourceReference(iu.getTargetResourceReference() + "_changed");
        
        // Specify some identifying information about installable unit.
        // None of this information is required in order to have a valid
        // descriptor, but typically it will be useful.
        Identity identity = baseFactory.createIdentity(new TranslatableString("A Wonderful Update","xKey_Wonderful_Update"));
        MaintenanceInformation maintInfo = baseFactory.createMaintenanceInformation();
        ManufacturerInformation mi =
            baseFactory.createManufacturerInformation(
                    new TranslatableString("Ed Co.", "Ed Co. Intl."));
        mi.setContactInformation(new TranslatableString("111-222-333","xKey_phone_number"));
        mi.setAddress(new TranslatableString("4321 Love SDD Lane", null));
        identity.setManufacturerInformation(mi);
        identity.setBuildID("build_ID_1234");
        maintInfo.setSeverity(new TranslatableString("Bad","xKey_Bad"));
        
        Collection<MaintenanceInformation> supersedesInfo = new ArrayList<MaintenanceInformation>();
        MaintenanceInformation supersedesInfoObject = baseFactory.createMaintenanceInformation();
        Collection<FixIdentity> supersededFixes = new ArrayList<FixIdentity>();
        supersededFixes.add(baseFactory.createFixIdentity("sfn_1"));
        supersededFixes.add(baseFactory.createFixIdentity("sfn_2"));
        supersededFixes.add(baseFactory.createFixIdentity("sfn_3"));
        supersedesInfoObject.setFixIdentityDefinitions(supersededFixes);

        supersedesInfo.add(supersedesInfoObject);
        maintInfo.setSupersedes(supersedesInfo);
        
        Collection<FixIdentity> fi = new ArrayList<FixIdentity>();
        FixIdentity fi1 = baseFactory.createFixIdentity("name_of_fix_1");
        fi1.setDescription(new TranslatableString("Description of fix","xKey_fix_desc"));

        fi.add(fi1);
        maintInfo.setFixIdentityDefinitions(fi);
        
        iu.setIdentityData(identity);
        
        
        // Define a requirement for the deployment of the installable unit.
        // This includes the definition of various constraints.
        Collection<Requirement> iuReqs = new ArrayList<Requirement>();
        Requirement iuReq = requirementFactory.createRequirement("req_ID");
        iuReq.setDisplayName(new TranslatableString("My_IU_Req",null));

        Collection<RequirementResourceConstraint> resourceConstraints = new ArrayList<RequirementResourceConstraint>();
        
        RequirementResourceConstraint resourceConstraint = requirementFactory.createRequirementResourceConstraint("My_res_con_ID", "My_res_ref");
        
//        Collection<CapacityConstraint> capacityConstraints = new ArrayList<CapacityConstraint>();
//        CapacityConstraint capacityConstraint = requirementFactory.createCapacityConstraint("capacity_property");
//        capacityConstraint.setMinimum("47");
//        capacityConstraint.setUnitOfMeasure("Mb");
//        capacityConstraint.setRecommendedMinimum("84");
//        capacityConstraint.setDescription(new TranslatableString("Memory",null));
//        capacityConstraints.add(capacityConstraint);
//        resourceConstraint.setCapacityConstraintArray(capacityConstraints);
        
        
        Collection<ConsumptionConstraint> consumptionConstraints = new ArrayList<ConsumptionConstraint>();
        ConsumptionConstraint consumptionConstraint = requirementFactory.createConsumptionConstraint("consumption_property");
//        consumptionConstraint.setValue("247");
//        consumptionConstraint.setUnitOfMeasure("Mb");
        consumptionConstraint.setDescription(new TranslatableString("Disk Space", "some_xKey"));
        consumptionConstraints.add(consumptionConstraint);
        resourceConstraint.setConsumptionConstraintArray(consumptionConstraints);
        
        Collection<PropertyConstraint> propertyConstraints = new ArrayList<PropertyConstraint>();
//        Collection<String> propertyValues = new ArrayList<String>();
//        propertyValues.add("foo");
//        propertyValues.add("bar");
//        PropertyConstraint propertyConstraint1 = requirementFactory.createPropertyConstraintMultiValue("Some_Property_Name", propertyValues);
//        ((PropertyConstraintMultiValue) propertyConstraint1).setPropertyMatchType("all");
//        propertyConstraints.add(propertyConstraint1);

        propertyConstraints.add(requirementFactory.createPropertyConstraintSingleValue("Some_Property_Name", "Some_Constraint_Value"));
        resourceConstraint.setPropertyConstraintArray(propertyConstraints);
        
        Collection<VersionConstraint> versionConstraints = new ArrayList<VersionConstraint>();
        VersionConstraint versionConstraint = requirementFactory.createVersionConstraint();
        Collection<VersionRange> ranges = new ArrayList<VersionRange>();
        VersionRange range1 = conditionFactory.createVersionRange();
        VersionRange range2 = conditionFactory.createVersionRange();
        range1.setMinimumVersion("3.6.2");
        range2.setMinimumVersion("3.5");
        range2.setMaximumVersion("3.5.9");
        Collection<String> fixNames = new ArrayList<String>();
        fixNames.add("fix1");
        fixNames.add("fix2");
        range2.setFixNames(fixNames);
        ranges.add(range1);
        ranges.add(range2);
        versionConstraint.setVersionRanges(ranges);
        
        Collection<VersionValue> versionValues = new ArrayList<VersionValue>();
        VersionValue versionValue1 = conditionFactory.createVersionValue("4.32.176");
        VersionValue versionValue2 =  conditionFactory.createVersionValue("8.2.160");
        Collection<String> fixNames2 = new ArrayList<String>();
        fixNames2.add("fix_foo");
        fixNames2.add("fix_bar");
        versionValue2.setFixNames(fixNames2);
        versionValues.add(versionValue1);
        versionValues.add(versionValue2);
        versionConstraint.setVersionValues(versionValues);
        
        Collection<VersionValue> certVersionValues = new ArrayList<VersionValue>();
        VersionValue certVersionValue = conditionFactory.createVersionValue("23.1.6.90");
        Collection<String> fixNames3 = new ArrayList<String>();
        fixNames3.add("fix_a");
        fixNames3.add("fix_b");
        fixNames3.add("fix_c");
        certVersionValue.setFixNames(fixNames3);
        certVersionValues.add(certVersionValue);
        versionConstraint.setCertifiedVersionValues(certVersionValues);
        
        versionConstraints.add(versionConstraint);
        
        resourceConstraint.setVersionConstraintArray(versionConstraints);
        
        resourceConstraints.add(resourceConstraint);
        
        iuReq.setResourceConstraints(resourceConstraints);
        
        Collection<AlternativeRequirement> altReqs = new ArrayList<AlternativeRequirement>();
        AlternativeRequirement altReq1 = requirementFactory.createAlternativeRequirement("ALT_REQ_ID_1");
        altReq1.setDisplayName(new TranslatableString("Some_Alt_Req",null));
        altReq1.setPriority(new BigInteger("1"));
        AlternativeRequirement altReq2 = requirementFactory.createAlternativeRequirement("ALT_REQ_ID_2");
        altReq2.setDisplayName(new TranslatableString("Some_Other_Alt_Req",null));
        altReq2.setPriority(new BigInteger("2"));

        Collection<RequirementResourceConstraint> altResourceConstraints = new ArrayList<RequirementResourceConstraint>();
        
        altResourceConstraints.add(requirementFactory.createRequirementResourceConstraint("alt_res_con", "alt_res_ref"));
        
        altReq2.setResourceConstraints(altResourceConstraints);
        
        altReqs.add(altReq1);
        altReqs.add(altReq2);

        iuReq.setAlternativeRequirements(altReqs);
        
        iuReqs.add(iuReq);
        
        iu.setRequirements(iuReqs);
        
        // Define a required base for the IU.
        RequiredBase rb = rbFactory.createRequiredBase();
        RequiredBaseConstraint rbc = rbFactory.createRequiredBaseConstraint("rbc_ID","rbc_Reference");
        rbc.setTestValue(Boolean.TRUE);
        rbc.setName("Some Required Base Constraint");
        rbc.setDescription(new TranslatableString("A Description of some Required Base Constraint",null));
        rbc.setVersionConstraint(versionConstraint);
        
        Collection<RequiredBaseConstraint> rbcArray = new ArrayList<RequiredBaseConstraint>();
        rbcArray.add(rbc);
        rb.setRequiredBaseConstraints(rbcArray);
        
        Collection<AlternativeRequiredBaseConstraint> arbcList = new ArrayList<AlternativeRequiredBaseConstraint>();
        
        AlternativeRequiredBaseConstraint arbc = rbFactory.createAlternativeRequiredBaseConstraint("arbc_id");
        arbc.setPriority(new BigInteger("3"));
        arbcList.add(arbc);
        rb.setAlternativeRequiredBaseConstraints(arbcList);
        
        iu.setRequiredBase(rb);
        
        Language lang1 = cuFactory.createLanguage("Portuguese");
        Language lang2 = cuFactory.createLanguage("Slovenian");
        Language lang3 = cuFactory.createLanguage("Czech");
        // Define some supported languages for the IU.
        Collection<Language> languages = new ArrayList<Language>();
        languages.add(lang1);
        languages.add(lang2);
        languages.add(lang3);
        iu.setLanguages(languages);
        
        // A restart may be required after the installation of the IU,
        // so define the conditions under which such a restart is necessary,
        // then add that information to the IU.
        Collection<Completion> completionObjects = new ArrayList<Completion>();
        Completion completionObject = cuFactory.createCompletion("restartRequired","completion_res_REF");
        completionObject.setDescription(new TranslatableString("description of a need for a restart",null));

        Condition c = conditionFactory.createCondition();
        Collection<String> operations = new ArrayList<String>();
        operations.add("install");
        operations.add("update");
        c.setOperations(operations);
        c.setDisplayName(new TranslatableString("The Name By Which Restarts Shall Be Known",null));
        
        Collection<AlternativeCondition> altConditions = new ArrayList<AlternativeCondition>();
        AlternativeCondition altCondition = conditionFactory.createAlternativeCondition("AC_ID");
        altCondition.setDescription(new TranslatableString("Alternative Condition Description", null));
        
        ConditionalResourceConstraint crc = conditionFactory.createConditionalResourceConstraint("Some_crc_ID", "Some_crc_ref");
        crc.setTestValue(Boolean.TRUE);
        
        Collection<VersionRange> crcRanges = new ArrayList<VersionRange>();
        VersionRange crcRange1 = conditionFactory.createVersionRange();
        VersionRange crcRange2 = conditionFactory.createVersionRange();
        crcRange1.setMinimumVersion("4.2");
        crcRange2.setMinimumVersion("4.1.2");
        crcRange2.setMaximumVersion("4.1.9");
        Collection<String> crcFixNames = new ArrayList<String>();
        crcFixNames.add("crc_fix1");
        crcFixNames.add("crc_fix2");
        crcFixNames.add("crc_fix3");
        crcRange2.setFixNames(crcFixNames);
        crcRanges.add(crcRange1);
        crcRanges.add(crcRange2);

        crc.setVersionRanges(crcRanges);
        
//        Collection<ConditionalPropertyConstraintSingleValue> cpcSV = new ArrayList<ConditionalPropertyConstraintSingleValue>();
//        
//        cpcSV.add(conditionFactory.createConditionalPropertyConstraintSingleValue("crcSV_name_1","crcSV_value_1"));
//
//        cpcSV.add(conditionFactory.createConditionalPropertyConstraintSingleValue("crcSV_name_2","crcSV_value_2"));
//        
//        crc.setConditionalSingleValuePropertyConstraints(cpcSV);
            
        Collection<ConditionalResourceConstraint> crcArray = new ArrayList<ConditionalResourceConstraint>();
        crcArray.add(crc);
        altCondition.setConditionalResourceConstraints(crcArray);
        altConditions.add(altCondition);
        c.setAlternativeConditions(altConditions);
        completionObject.setCondition(c);
        completionObjects.add(completionObject);

        iu.setCompletion(completionObjects);
        
        // Define properties and variables, and add them to the IU.
        Collection<org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty> rpArray = new ArrayList<org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty>();
        rpArray.add(variableFactory.createResourceProperty("RP_ID_1","RP_REF_1"));
        rpArray.add(variableFactory.createResourceProperty("RP_ID_2","RP_REF_2"));
        org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty rp = variableFactory.createResourceProperty("RP_ID_3","RP_REF_3");
        rp.setSensitive(Boolean.FALSE);
        rp.setPropertyName("RP_PROP_NAME");
        rpArray.add(rp);
        iu.setResourceProperties(rpArray);
        
        Collection<DerivedVariable> dvArray = new ArrayList<DerivedVariable>();
        DerivedVariable dv1 = variableFactory.createDerivedVariable("DV_ID_1","DV_EXP_1");
        dvArray.add(variableFactory.createDerivedVariable("DV_ID_2","DV_EXP_2"));
        dv1.setSensitive(Boolean.TRUE);
        dvArray.add(dv1);
        iu.setDerivedVariables(dvArray);

        Collection<ConditionalDerivedVariableExpression> cdvExps = new ArrayList<ConditionalDerivedVariableExpression>();
        cdvExps.add(variableFactory.createConditionalDerivedVariableExpression("exp_1",c));

        Collection<ConditionalDerivedVariable> cdvArray = new ArrayList<ConditionalDerivedVariable>();
        ConditionalDerivedVariable cdv = variableFactory.createConditionalDerivedVariable("CDV_ID_1",cdvExps);
        cdv.setSensitive(Boolean.TRUE);
        cdvArray.add(cdv);
        iu.setConditionalDerivedVariables(cdvArray);
        
        
        // Define groups of parameters and add them to the IU.
        Collection<BooleanParameter> booleanParameters = new ArrayList<BooleanParameter>();
        booleanParameters.add(variableFactory.createBooleanParameter("some_BP_ID"));
        booleanParameters.add(variableFactory.createBooleanParameter("some_BP_ID_2"));
        BooleanParameter booleanParameter = variableFactory.createBooleanParameter("some_BP_ID_3");
        Collection<String> booleanOperations = new ArrayList<String>();
        booleanOperations.add("install");
        booleanParameter.setOperations(booleanOperations);
        Collection<ParameterGroup> pg = new ArrayList<ParameterGroup>();
        ParameterGroup pg1 = variableFactory.createParameterGroup();
        pg1.setBooleanParameters(booleanParameters);
        pg.add(pg1);
        
        Collection<IntegerParameter> integerParameters = new ArrayList<IntegerParameter>();
        integerParameters.add(variableFactory.createIntegerParameter("INT_ID_1"));
        IntegerParameter integerParameter = variableFactory.createIntegerParameter("INT_ID_2");
        Collection<ParameterBoundary> integerParameterBoundaries = new ArrayList<ParameterBoundary>();
        ParameterBoundary integerParameterBoundary = variableFactory.createParameterBoundary();
        integerParameterBoundary.setLowerBound(new Integer("3"));
        integerParameterBoundary.setUpperBound(new Integer("8"));
        integerParameterBoundaries.add(integerParameterBoundary);
        integerParameter.setBounds(integerParameterBoundaries);
        integerParameters.add(integerParameter);
        
        booleanParameters = new ArrayList<BooleanParameter>();
        booleanParameter = variableFactory.createBooleanParameter("Another_BP_ID");
        booleanParameter.setDisplayName(new TranslatableString("BP_NAME",null));
        
        booleanParameter.setRequired(Boolean.TRUE);
        booleanParameters.add(booleanParameter);
        booleanParameters.add(variableFactory.createBooleanParameter("Another_BP_ID_2"));
        
        ParameterGroup pg2 = variableFactory.createParameterGroup();
        pg2.setBooleanParameters(booleanParameters);
        pg2.setIntegerParameters(integerParameters);
        
        Collection<URIParameter> uriParameters = new ArrayList<URIParameter>();
        URIParameter uriParameter = variableFactory.createURIParameter("URI_ID");
        uriParameter.setRequired(Boolean.FALSE);
        uriParameter.setSensitive(Boolean.TRUE);
        uriParameters.add(uriParameter);
        pg2.setURIParameters(uriParameters);
        
        Collection<StringParameter> stringParameters = new ArrayList<StringParameter>();
        stringParameters.add(variableFactory.createStringParameter("STR_PARM_ID_1"));
        StringParameter stringParameter = variableFactory.createStringParameter("STR_PARM_ID_2");
        stringParameter.setDefaultValue("STR_PARM_DEFAULT");
        Collection<String> alts = new ArrayList<String>();
        alts.add("STR_PARM_ALT_1");
        alts.add("STR_PARM_ALT_2");
        stringParameter.setValidValues(alts);
        stringParameters.add(stringParameter);
        pg2.setStringParameters(stringParameters);
        pg.add(pg2);
        
        iu.setParameterGroups(pg);
        
        Collection<ResultingResource> resultingResources = new ArrayList<ResultingResource>();
        ResultingResource resultingResource = cuFactory.createResultingResource("Resulting_Resource_Reference");
        Collection<String> rrFixNames = new ArrayList<String>();
        rrFixNames.add("RR_Fix_1");
        rrFixNames.add("RR_Fix_2");
        resultingResource.setFixNames(rrFixNames);
        Properties resultingResourceProperties = new Properties();
        resultingResourceProperties.setProperty("X", "property X");
        resultingResourceProperties.setProperty("Y", "property Y");
        resultingResource.setProperties(resultingResourceProperties);
        resultingResources.add(resultingResource);
        iu.setResultingResources(resultingResources);
        
        Collection<ResultingChange> resultingChanges = new ArrayList<ResultingChange>();
        ResultingChange resultingChange = cuFactory.createResultingChange();
        resultingChange.setName("Resulting Change Name");
        Properties newResultingChangeProperties = new Properties();
        newResultingChangeProperties.setProperty("p1", "property one");
        newResultingChangeProperties.setProperty("p2", "property two");
        resultingChange.setProperties(newResultingChangeProperties);
        resultingChanges.add(resultingChange);
        
        iu.setResultingChanges(resultingChanges);
        byte[] descriptorID = {127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};
        DeploymentDescriptor dd = baseFactory.createDeploymentDescriptor("1.8", descriptorID, new Date(), iu, resources);
        
        System.out.println("\n");

        try
        {
            // Prepare the DOM document for writing
            Document doc = (Document) ((SPIDataObject) dd).getElement().getParentNode();

            DOMImplementationRegistry domRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImpl = (DOMImplementationLS) domRegistry.getDOMImplementation("LS");
            LSSerializer serializer = domImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("format-pretty-print", true);
            
            String s = serializer.writeToString(doc);
            System.out.println(s);

        }
        catch (ClassCastException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (ClassNotFoundException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (InstantiationException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IllegalAccessException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

//        try
//        {
//            Document doc = (Document) ((SPIDataObject) dd).getElement();
//            SDD_DAS das = new SDD_DASImpl();
//            das.saveDataGraph(doc, System.out, "UTF-8");
//        }
//        catch (XMLValidationException e)
//        {
//            e.printStackTrace();
//        }
//        catch (IOException e)
//        {
//            e.printStackTrace();
//        }

        System.out.println("\n\n");
        System.out.println("\nListing strings for translation...\n");
        Properties p = dd.getTranslatableStrings();
        
        String key;
        for (Enumeration<Object> keys = p.keys(); keys.hasMoreElements(); )
        {
            key = (String) keys.nextElement();
            System.out.println(key + "=\"" + p.getProperty(key) + "\"");
        }
    }
}
